/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppZip {
    private static final Logger logger = LoggerFactory.getLogger(AppZip.class);
    private static final String OUTPUT_ZIP_FILE = "/home/fabio/desktop.zip";
    private static final String SOURCE_FOLDER = "/home/fabio/Desktop";
    private static final String DEST_FOLDER = "/home/fabio/Desktop_Unzipped";
    private final List<String> fileList = new ArrayList<String>();
    private final String sourceFolder;

    public static void main(String[] args) throws IOException {
        File destination = new File(DEST_FOLDER);
        int unzipped = AppZip.unzipToDirectory(OUTPUT_ZIP_FILE, destination);
        System.out.println("DONE, zipped = 0; unzipped = " + unzipped);
    }

    public AppZip(String toZipFolder) {
        this.sourceFolder = toZipFolder;
        this.generateFileList(new File(toZipFolder));
    }

    public int zipIt(String zipFile) throws IOException {
        int zippedFiles = 0;
        byte[] buffer = new byte[1024];
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (String file : this.fileList) {
            int len;
            ZipEntry ze = new ZipEntry(file);
            zos.putNextEntry(ze);
            FileInputStream in = new FileInputStream(String.valueOf(this.sourceFolder) + File.separator + file);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
            ++zippedFiles;
        }
        zos.closeEntry();
        zos.close();
        return zippedFiles;
    }

    public void generateFileList(File node) {
        if (node.isFile()) {
            this.fileList.add(this.generateZipEntry(node.getAbsoluteFile().toString()));
        }
        if (node.isDirectory()) {
            String[] subNote;
            String[] stringArray = subNote = node.list();
            int n = subNote.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                this.generateFileList(new File(node, filename));
                ++n2;
            }
        }
    }

    private String generateZipEntry(String file) {
        return file.substring(this.sourceFolder.length() + 1, file.length());
    }

    public static int unzipToDirectory(String zipName, File destinationFolder) throws IOException {
        destinationFolder.mkdirs();
        ZipFile zipFile = new ZipFile(zipName);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        int unzippedCount = 0;
        while (enumeration.hasMoreElements()) {
            int size;
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            String zipAbsoluteName = zipEntry.getName();
            if (zipAbsoluteName.contains(File.separator)) {
                File subDir = new File(destinationFolder, zipAbsoluteName.substring(0, zipAbsoluteName.lastIndexOf(File.separator)));
                subDir.mkdirs();
            }
            File toWrite = new File(destinationFolder, zipAbsoluteName);
            BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            byte[] buffer = new byte[2048];
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(toWrite), buffer.length);
            while ((size = bis.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            bis.close();
            ++unzippedCount;
        }
        return unzippedCount;
    }
}

