package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.CustomQueryDescriptorStubs;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.CustomQueryDescriptorFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.common.core.utils.logging.GCUBELog;

public class CustomQueryDescriptor {

	static GCUBELog logger= new GCUBELog(Analysis.class);
	
	private String user="";
	private Long rows=0l;
	private ArrayList<Field> fields = new ArrayList<Field>();
	private ExportStatus status=ExportStatus.PENDING;
	private String errorMessage="";
	private String actualTableName;
	private String query="";
	private Long creationTime=0l;
	private Long lastAccess=0l;
	
	public CustomQueryDescriptor() {
		// TODO Auto-generated constructor stub
	}
	
	public static ArrayList<CustomQueryDescriptor> loadResultSet(ResultSet rs)throws Exception{
		ArrayList<CustomQueryDescriptor> toReturn= new ArrayList<CustomQueryDescriptor>();
		while(rs.next()){
			toReturn.add(new CustomQueryDescriptor(Field.loadRow(rs)));
		}
		return toReturn;
	}
	
	public CustomQueryDescriptor(ResultSet rs)throws Exception{
		this(Field.loadRow(rs));
	}
	public CustomQueryDescriptor(List<Field> row){
		for(Field f: row)	
			try{
				this.setField(f);
			}catch(Exception e){
				//skips wrong fields
			}
	}
	
	
	public boolean setField(Field f) throws JSONException{
		try{
		switch(CustomQueryDescriptorFields.valueOf(f.getName().toLowerCase())){
		case count : setRows(f.getValueAsLong());
		break;
		case creationtime: setCreationTime(f.getValueAsLong());
		break;
		case errors: setErrorMessage(f.getValue());
		break;
		case fields : setFields((ArrayList<Field>) AquaMapsXStream.getXMLInstance().fromXML(f.getValue()));
		break;
		case lastaccess : setLastAccess(f.getValueAsLong());
		break;
		case query : setQuery(f.getValue());
		break;
		case resulttable : setActualTableName(f.getValue());
		break;
		case status : setStatus(ExportStatus.fromValue(f.getValue()));
		break;
		case userid : setUser(f.getValue());
		default : return false;
		}
	}catch(Exception e){logger.warn("Unable to parse field "+f.toJSONObject(),e);}
		return true;
	}
	
	
	public Field getField(CustomQueryDescriptorFields fieldName){
		switch(fieldName){
		case count : return new Field(fieldName+"",getRows()+"",FieldType.LONG);
		case creationtime : return new Field(fieldName+"",getCreationTime()+"",FieldType.LONG);
		case errors : return new Field(fieldName+"",getErrorMessage(),FieldType.STRING);
		case fields: return new Field(fieldName+"",AquaMapsXStream.getXMLInstance().toXML(getFields()),FieldType.STRING);
		case lastaccess: return new Field(fieldName+"",getLastAccess()+"",FieldType.LONG);
		case query: return new Field(fieldName+"",getQuery(),FieldType.STRING);
		case resulttable: return new Field(fieldName+"",getActualTableName(),FieldType.STRING);
		case status: return new Field(fieldName+"",getStatus()+"",FieldType.STRING);
		case userid : return new Field(fieldName+"",getUser(),FieldType.STRING);
		default : return null;
		}
	}
	
	
	public List<Field> toRow() throws JSONException{
		List<Field> toReturn= new ArrayList<Field>();
		for(CustomQueryDescriptorFields f : CustomQueryDescriptorFields.values())
			toReturn.add(getField(f));
		return toReturn;
	}

	/**
	 * @return the user
	 */
	public String getUser() {
		return user;
	}

	/**
	 * @param user the user to set
	 */
	public void setUser(String user) {
		this.user = user;
	}

	/**
	 * @return the rows
	 */
	public Long getRows() {
		return rows;
	}

	/**
	 * @param rows the rows to set
	 */
	public void setRows(Long rows) {
		this.rows = rows;
	}

	/**
	 * @return the fields
	 */
	public ArrayList<Field> getFields() {
		return fields;
	}

	/**
	 * @param fields the fields to set
	 */
	public void setFields(ArrayList<Field> fields) {
		this.fields = fields;
	}

	/**
	 * @return the status
	 */
	public ExportStatus getStatus() {
		return status;
	}

	/**
	 * @param status the status to set
	 */
	public void setStatus(ExportStatus status) {
		this.status = status;
	}

	/**
	 * @return the errorMessage
	 */
	public String getErrorMessage() {
		return errorMessage;
	}

	/**
	 * @param errorMessage the errorMessage to set
	 */
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	/**
	 * @return the actualTableName
	 */
	public String getActualTableName() {
		return actualTableName;
	}

	/**
	 * @param actualTableName the actualTableName to set
	 */
	public void setActualTableName(String actualTableName) {
		this.actualTableName = actualTableName;
	}

	/**
	 * @return the query
	 */
	public String getQuery() {
		return query;
	}

	/**
	 * @param query the query to set
	 */
	public void setQuery(String query) {
		this.query = query;
	}

	/**
	 * @return the creationTime
	 */
	public Long getCreationTime() {
		return creationTime;
	}

	/**
	 * @param creationTime the creationTime to set
	 */
	public void setCreationTime(Long creationTime) {
		this.creationTime = creationTime;
	}

	/**
	 * @return the lastAccess
	 */
	public Long getLastAccess() {
		return lastAccess;
	}

	/**
	 * @param lastAccess the lastAccess to set
	 */
	public void setLastAccess(Long lastAccess) {
		this.lastAccess = lastAccess;
	}
	
	public CustomQueryDescriptorStubs toStubsVersion(){
		CustomQueryDescriptorStubs toReturn=new CustomQueryDescriptorStubs();
		toReturn.setActualTableName(actualTableName);
		toReturn.setErrorMsg(errorMessage);
		toReturn.setFields(Field.toStubsVersion(fields));
		toReturn.setQuery(query);
		toReturn.setRows(rows);
		toReturn.setStatus(status);
		toReturn.setUser(user);
		return toReturn;
	}
	
	public CustomQueryDescriptor(CustomQueryDescriptorStubs stubs){
		setActualTableName(stubs.getActualTableName());
		setCreationTime(stubs.getCreationTime());
		setErrorMessage(stubs.getErrorMsg());
		fields.addAll(Field.load(stubs.getFields()));
		setLastAccess(stubs.getLastAccess());
		setQuery(stubs.getQuery());
		setRows(stubs.getRows());
		setStatus(stubs.getStatus());
		setUser(stubs.getUser());
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("CustomQueryDescriptor [user=");
		builder.append(user);
		builder.append(", rows=");
		builder.append(rows);
		builder.append(", fields=");
		builder.append(fields);
		builder.append(", status=");
		builder.append(status);
		builder.append(", errorMessage=");
		builder.append(errorMessage);
		builder.append(", actualTableName=");
		builder.append(actualTableName);
		builder.append(", query=");
		builder.append(query);
		builder.append(", creationTime=");
		builder.append(creationTime);
		builder.append(", lastAccess=");
		builder.append(lastAccess);
		builder.append("]");
		return builder.toString();
	}
	
	
}
