package org.gcube.application.aquamaps.aquamapsservice.client.proxies;

import java.io.File;
import java.net.URI;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

import org.gcube.application.aquamaps.aquamapsservice.stubs.AquaMapsServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CalculateEnvelopefromCellSelectionRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesByFiltersRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.GetSpeciesEnvelopeRequestType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.AquaMapsObject;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.BoundingBox;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Envelope;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Filter;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Job;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Species;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Submitted;
import org.gcube.application.aquamaps.aquamapsservice.stubs.wrapper.utils.RSWrapper;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.StringArray;
import org.gcube_system.namespaces.application.aquamaps.types.AquaMap;
import org.gcube_system.namespaces.application.aquamaps.types.PagedRequestSettings;

public class DefaultMaps implements Maps {

	private final ProxyDelegate<AquaMapsServicePortType> delegate;

	public DefaultMaps(ProxyDelegate<AquaMapsServicePortType> delegate) {
		this.delegate = delegate;
	}
	
	
	//********************** OPERATIONS
	
	@Override
	public Envelope calculateEnvelope(BoundingBox bb, List<Area> areas,
			final String speciesId, boolean useBottom, boolean useBounding,
			boolean useFAO) throws RemoteException, Exception {
		final CalculateEnvelopeRequestType request=new CalculateEnvelopeRequestType();
		request.setBoundingEast(bb.getE());
		request.setBoundingNorth(bb.getN());
		request.setBoundingSouth(bb.getS());
		request.setBoundingWest(bb.getW());

		StringBuilder areaSelection=new StringBuilder();
		for(Area a: areas) areaSelection.append(a.getCode()+",");
		areaSelection.deleteCharAt(areaSelection.lastIndexOf(","));
		request.setFaoAreas(areaSelection.toString());

		request.setSpeciesID(speciesId);
		request.setUseBottomSeaTempAndSalinity(useBottom);
		request.setUseBounding(useBounding);
		request.setUseFAO(useFAO);
		
		Call<AquaMapsServicePortType,Envelope> call=new Call<AquaMapsServicePortType, Envelope>() {
			@Override
			public Envelope call(AquaMapsServicePortType pt)
					throws Exception {
				Species s=new Species(speciesId);
				s.getAttributesList().addAll(Field.load(pt.calculateEnvelope(request)));
				return s.extractEnvelope();
			}
		};
		return delegate.make(call);
	}
	
	
	@Override
	public Envelope calculateEnvelopeFromCellSelection(List<String> cellIds,
			final String speciesId) throws RemoteException, Exception {
		
		final CalculateEnvelopefromCellSelectionRequestType request=new CalculateEnvelopefromCellSelectionRequestType();
		request.setCellIds(new StringArray(cellIds.toArray(new String[cellIds.size()])));
		request.setSpeciesID(speciesId);
		
		Call<AquaMapsServicePortType,Envelope> call=new Call<AquaMapsServicePortType, Envelope>() {
			@Override
			public Envelope call(AquaMapsServicePortType pt)
					throws Exception {
				Species s=new Species(speciesId);
				s.getAttributesList().addAll(Field.load(pt.calculateEnvelopefromCellSelection(request)));
				return s.extractEnvelope();
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public int deleteSubmitted(final List<Integer> ids) throws RemoteException,
			Exception {
		Call<AquaMapsServicePortType,Integer> call=new Call<AquaMapsServicePortType, Integer>() {
			@Override
			public Integer call(AquaMapsServicePortType pt)
					throws Exception {
				String[] array=new String[ids.size()];
				for(int i=0;i<ids.size();i++) array[i]=String.valueOf(ids.get(i));
				return pt.deleteSubmitted(new StringArray(array));
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public void markSaved(final List<Integer> submittedIds) throws RemoteException,
			Exception {
		Call<AquaMapsServicePortType, Object> call=new Call<AquaMapsServicePortType, Object>() {
			
			@Override
			public Object call(AquaMapsServicePortType endpoint) throws Exception {
				List<String> ids=new ArrayList<String>();
				for(Integer id:submittedIds)ids.add(String.valueOf(id));
				endpoint.markSaved(new StringArray(ids.toArray(new String[ids.size()])));
				return null;
			}
		};
		delegate.make(call);
	}
	
	@Override
	public void submitJob(final Job toSubmit) throws RemoteException, Exception {
		Call<AquaMapsServicePortType,Object> call=new Call<AquaMapsServicePortType, Object>() {
			
			@Override
			public Object call(AquaMapsServicePortType endpoint) throws Exception {
				endpoint.submitJob(toSubmit.toStubsVersion());
				return null;
			}
		};
		delegate.make(call);
	}
	
	
	
	//****************************** JSON
	
//	@Override
//	public String getJSONSubmitted(String userName, boolean showObjects,
//			String date, Integer jobId, SubmittedStatus status,
//			ObjectType objType, PagedRequestSettings settings)
//			throws RemoteException, Exception {
//		
//		final GetAquaMapsPerUserRequestType request=new GetAquaMapsPerUserRequestType();
//		request.setUserID(userName);
//		request.setAquamaps(showObjects);
//		request.setDateEnabled(date!=null);
//		if(date!=null)request.setDateValue(date);
//		request.setJobIdEnabled(jobId!=null);
//		if(jobId!=null)request.setJobIdValue(jobId);
//		request.setJobStatusEnabled(false);
//		request.setJobStatusValue(null);
//		request.setObjectStatusEnabled(status!=null);
//		if(status!=null)request.setObjectStatusValue(status.toString());
//		request.setPagedRequestSettings(settings);
//		request.setTypeEnabled(objType!=null);
//		if(objType!=null)request.setTypeValue(objType.toString());
//		
//		Call<AquaMapsServicePortType,String> call=new Call<AquaMapsServicePortType, String>() {
//			@Override
//			public String call(AquaMapsServicePortType pt)
//					throws Exception {
//				return pt.getAquaMapsPerUser(request);
//			}
//		};
//		return delegate.make(call);
//	}
//	
//	@Override
//	public String getJSONOccurrenceCells(String speciesId,
//			PagedRequestSettings settings) throws RemoteException, Exception {
//		final GetOccurrenceCellsRequestType request= new GetOccurrenceCellsRequestType();
//		request.setSpeciesID(speciesId);
//		request.setPagedRequestSettings(settings);
//		
//		Call<AquaMapsServicePortType,String> call=new Call<AquaMapsServicePortType, String>() {
//			@Override
//			public String call(AquaMapsServicePortType pt)
//					throws Exception {
//				return pt.getOccurrenceCells(request);
//			}
//		};
//		return delegate.make(call);
//	}
//	
//	@Override
//	public String getJSONResources(PagedRequestSettings settings,
//			List<Field> filter) throws RemoteException, Exception {
//		final GetResourceListRequestType request=new GetResourceListRequestType();
//		request.setFilters(Field.toStubsVersion(filter));
//		request.setPagedRequestSettings(settings);
//		Call<AquaMapsServicePortType,String> call=new Call<AquaMapsServicePortType, String>() {
//			@Override
//			public String call(AquaMapsServicePortType pt)
//			throws Exception {
//				return pt.getResourceList(request);
//			}
//		};
//		return delegate.make(call);
//	}
	
	
	@Override
	public String getJSONSpecies(int hspenId, List<Filter> genericSearch,
			List<Filter> advancedFilters, PagedRequestSettings settings)
	throws RemoteException, Exception {
		final GetSpeciesByFiltersRequestType request=new GetSpeciesByFiltersRequestType();
		request.setGenericSearchFilters(Filter.toStubsVersion(genericSearch));
		request.setSpecieficFilters(Filter.toStubsVersion(advancedFilters));
		request.setHspen(hspenId);
		request.setPagedRequestSettings(settings);
		Call<AquaMapsServicePortType,String> call=new Call<AquaMapsServicePortType, String>() {
			@Override
			public String call(AquaMapsServicePortType pt)
			throws Exception {
				return pt.getSpeciesByFilters(request);
			}
		};
		return delegate.make(call);
	}
	
//	@Override
//	public String getJSONPhilogeny(SpeciesOccursumFields level,
//			ArrayList<Field> filters, PagedRequestSettings settings)
//			throws RemoteException, Exception {
//		final GetPhylogenyRequestType request=new GetPhylogenyRequestType();
//		request.setFieldList(Field.toStubsVersion(filters));
//		request.setPagedRequestSettings(settings);
//		request.setToSelect(new Field(level+"","",FieldType.STRING).toStubsVersion());
//		
//		Call<AquaMapsServicePortType,String> call=new Call<AquaMapsServicePortType, String>() {
//			@Override
//			public String call(AquaMapsServicePortType pt)
//			throws Exception {
//				return pt.getPhylogeny(request);
//			}
//		};
//		return delegate.make(call);
//	}
	
	
	//******************************* LOAD OBJECT
	
	@Override
	public AquaMapsObject loadObject(final int objectId) throws RemoteException,
			Exception {
		
		Call<AquaMapsServicePortType,AquaMapsObject> call=new Call<AquaMapsServicePortType, AquaMapsObject>() {
			
			@Override
			public AquaMapsObject call(AquaMapsServicePortType endpoint)
					throws Exception {
				AquaMap returned=endpoint.getObject(objectId);
				return new AquaMapsObject(returned);
			}
		};
		
		return delegate.make(call);
	}
	

	
	@Override
	public Species loadEnvelope(final String speciesId, int hspenId)
			throws RemoteException, Exception {
		final GetSpeciesEnvelopeRequestType req=new GetSpeciesEnvelopeRequestType(hspenId, speciesId);
		Call<AquaMapsServicePortType,Species> call=new Call<AquaMapsServicePortType, Species>() {
			
			@Override
			public Species call(AquaMapsServicePortType endpoint) throws Exception {
				Species spec=new Species(speciesId);
				spec.getAttributesList().addAll(Field.load(endpoint.getSpeciesEnvelop(req)));
				return spec;
			}
		};
		return delegate.make(call);
	}
	
	@Override
	public Submitted loadSubmittedById(final int id) throws RemoteException,
			Exception {
		Call<AquaMapsServicePortType,Submitted> call=new Call<AquaMapsServicePortType, Submitted>() {
			
			@Override
			public Submitted call(AquaMapsServicePortType endpoint) throws Exception {
				return new Submitted(endpoint.loadSubmittedById(id));
			}
		};
		return delegate.make(call);
	}
	
	
	@Override
	public File getCSVSpecies(int hspenId, List<Filter> genericSearch,
			List<Filter> advancedFilters) throws RemoteException, Exception {
		final GetSpeciesByFiltersRequestType request=new GetSpeciesByFiltersRequestType();
		request.setGenericSearchFilters(Filter.toStubsVersion(genericSearch));
		request.setSpecieficFilters(Filter.toStubsVersion(advancedFilters));
		request.setHspen(hspenId);
		
		Call<AquaMapsServicePortType,File> call= new Call<AquaMapsServicePortType, File>() {
			
			@Override
			public File call(AquaMapsServicePortType pt) throws Exception {
				String locator=pt.getSpeciesByFiltersASCSV(request);						
				return RSWrapper.getStreamFromLocator(new URI(locator));
			}
		}; 
		return delegate.make(call);
	}
}
