package org.gcube.application.aquamaps.aquamapsservice.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.application.aquamaps.aquamapsservice.client.Constants;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DefaultPublisher;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.Publisher;
import org.gcube.application.aquamaps.aquamapsservice.stubs.PublisherServicePortType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.service.PublisherServiceAddressingLocator;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;


public class PublisherPlugin extends AbstractPlugin<PublisherServicePortType,Publisher> {

	public PublisherPlugin() {
		super(Constants.NAMESPACE+"/PublisherService");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public Publisher newProxy(ProxyDelegate<PublisherServicePortType> delegate) {
		return new DefaultPublisher(delegate);
	}

	@Override
	public PublisherServicePortType resolve(EndpointReferenceType address,
			ProxyConfig<?, ?> config) throws Exception {
		return new PublisherServiceAddressingLocator().getPublisherServicePortTypePort(address);
	}

}
