/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsservice.stubs.CustomQueryDescriptorStubs;
import org.gcube.application.aquamaps.aquamapsservice.stubs.ExportStatus;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Analysis;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.fields.CustomQueryDescriptorFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.json.JSONException;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.xstream.AquaMapsXStream;
import org.gcube.common.core.utils.logging.GCUBELog;

public class CustomQueryDescriptor {
    static GCUBELog logger = new GCUBELog(Analysis.class);
    private String user = "";
    private Long rows = 0L;
    private ArrayList<Field> fields = new ArrayList();
    private ExportStatus status = ExportStatus.PENDING;
    private String errorMessage = "";
    private String actualTableName;
    private String query = "";
    private Long creationTime = 0L;
    private Long lastAccess = 0L;

    public CustomQueryDescriptor() {
    }

    public static ArrayList<CustomQueryDescriptor> loadResultSet(ResultSet rs) throws Exception {
        ArrayList<CustomQueryDescriptor> toReturn = new ArrayList<CustomQueryDescriptor>();
        while (rs.next()) {
            toReturn.add(new CustomQueryDescriptor(Field.loadRow(rs)));
        }
        return toReturn;
    }

    public CustomQueryDescriptor(ResultSet rs) throws Exception {
        this(Field.loadRow(rs));
    }

    public CustomQueryDescriptor(List<Field> row) {
        for (Field f : row) {
            try {
                this.setField(f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean setField(Field f) throws JSONException {
        try {
            switch (CustomQueryDescriptorFields.valueOf(f.getName().toLowerCase())) {
                case count: {
                    this.setRows(f.getValueAsLong());
                    break;
                }
                case creationtime: {
                    this.setCreationTime(f.getValueAsLong());
                    break;
                }
                case errors: {
                    this.setErrorMessage(f.getValue());
                    break;
                }
                case fields: {
                    this.setFields((ArrayList)AquaMapsXStream.getXMLInstance().fromXML(f.getValue()));
                    break;
                }
                case lastaccess: {
                    this.setLastAccess(f.getValueAsLong());
                    break;
                }
                case query: {
                    this.setQuery(f.getValue());
                    break;
                }
                case resulttable: {
                    this.setActualTableName(f.getValue());
                    break;
                }
                case status: {
                    this.setStatus(ExportStatus.fromValue((String)f.getValue()));
                    break;
                }
                case userid: {
                    this.setUser(f.getValue());
                }
                default: {
                    return false;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to parse field " + f.toJSONObject()), (Throwable)e);
        }
        return true;
    }

    public Field getField(CustomQueryDescriptorFields fieldName) {
        switch (fieldName) {
            case count: {
                return new Field("" + (Object)((Object)fieldName), "" + this.getRows(), FieldType.LONG);
            }
            case creationtime: {
                return new Field("" + (Object)((Object)fieldName), "" + this.getCreationTime(), FieldType.LONG);
            }
            case errors: {
                return new Field("" + (Object)((Object)fieldName), this.getErrorMessage(), FieldType.STRING);
            }
            case fields: {
                return new Field("" + (Object)((Object)fieldName), AquaMapsXStream.getXMLInstance().toXML(this.getFields()), FieldType.STRING);
            }
            case lastaccess: {
                return new Field("" + (Object)((Object)fieldName), "" + this.getLastAccess(), FieldType.LONG);
            }
            case query: {
                return new Field("" + (Object)((Object)fieldName), this.getQuery(), FieldType.STRING);
            }
            case resulttable: {
                return new Field("" + (Object)((Object)fieldName), this.getActualTableName(), FieldType.STRING);
            }
            case status: {
                return new Field("" + (Object)((Object)fieldName), "" + this.getStatus(), FieldType.STRING);
            }
            case userid: {
                return new Field("" + (Object)((Object)fieldName), this.getUser(), FieldType.STRING);
            }
        }
        return null;
    }

    public List<Field> toRow() throws JSONException {
        ArrayList<Field> toReturn = new ArrayList<Field>();
        CustomQueryDescriptorFields[] customQueryDescriptorFieldsArray = CustomQueryDescriptorFields.values();
        int n = customQueryDescriptorFieldsArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomQueryDescriptorFields f = customQueryDescriptorFieldsArray[n2];
            toReturn.add(this.getField(f));
            ++n2;
        }
        return toReturn;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Long getRows() {
        return this.rows;
    }

    public void setRows(Long rows) {
        this.rows = rows;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public void setFields(ArrayList<Field> fields) {
        this.fields = fields;
    }

    public ExportStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExportStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getActualTableName() {
        return this.actualTableName;
    }

    public void setActualTableName(String actualTableName) {
        this.actualTableName = actualTableName;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public Long getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Long lastAccess) {
        this.lastAccess = lastAccess;
    }

    public CustomQueryDescriptorStubs toStubsVersion() {
        CustomQueryDescriptorStubs toReturn = new CustomQueryDescriptorStubs();
        toReturn.setActualTableName(this.actualTableName);
        toReturn.setErrorMsg(this.errorMessage);
        toReturn.setFields(Field.toStubsVersion(this.fields));
        toReturn.setQuery(this.query);
        toReturn.setRows(this.rows.longValue());
        toReturn.setStatus(this.status);
        toReturn.setUser(this.user);
        return toReturn;
    }

    public CustomQueryDescriptor(CustomQueryDescriptorStubs stubs) {
        this.setActualTableName(stubs.getActualTableName());
        this.setCreationTime(stubs.getCreationTime());
        this.setErrorMessage(stubs.getErrorMsg());
        this.fields.addAll(Field.load(stubs.getFields()));
        this.setLastAccess(stubs.getLastAccess());
        this.setQuery(stubs.getQuery());
        this.setRows(stubs.getRows());
        this.setStatus(stubs.getStatus());
        this.setUser(stubs.getUser());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CustomQueryDescriptor [user=");
        builder.append(this.user);
        builder.append(", rows=");
        builder.append(this.rows);
        builder.append(", fields=");
        builder.append(this.fields);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", errorMessage=");
        builder.append(this.errorMessage);
        builder.append(", actualTableName=");
        builder.append(this.actualTableName);
        builder.append(", query=");
        builder.append(this.query);
        builder.append(", creationTime=");
        builder.append(this.creationTime);
        builder.append(", lastAccess=");
        builder.append(this.lastAccess);
        builder.append("]");
        return builder.toString();
    }
}

