/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SubmittedFields;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.client.plugins.AbstractPlugin;
import org.gcube.application.aquamaps.aquamapsservice.client.proxies.DataManagement;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.fields.MetaSourceFields;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.Field;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.FieldType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.ResourceType;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.SystemTable;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeServlet
extends CustomServlet {
    private static final long serialVersionUID = -3832557273021635458L;
    private static final Logger logger = LoggerFactory.getLogger(TreeServlet.class);

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String type = request.getParameter("treeType");
        logger.trace("TreeServlet-handleRequest type : " + type);
        if (type == null) {
            response.setStatus(400);
        } else {
            ArrayList<Field> filter = new ArrayList<Field>();
            if (type != null) {
                filter.add(new Field(MetaSourceFields.type + "", ResourceType.valueOf((String)type) + "", FieldType.STRING));
            }
            response.setContentType("application/json; charset=utf-8");
            response.setStatus(200);
            int startIndex = 0;
            int limit = 100;
            try {
                startIndex = Integer.parseInt(request.getParameter("start"));
                limit = Integer.parseInt(request.getParameter("limit"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            String sortColumn = request.getParameter("sort");
            String sortDir = request.getParameter("dir");
            if (sortColumn == null) {
                sortColumn = SubmittedFields.searchid + "";
            }
            if (sortDir == null) {
                sortDir = "ASC";
            }
            try {
                ASLSession session = Utils.getSession((HttpSession)request.getSession());
                ScopeProvider.instance.set(session.getScope().toString());
                DataManagement dm = (DataManagement)AbstractPlugin.dataManagement().build();
                String submittedTableName = dm.getSystemTableName(SystemTable.DATASOURCES_METADATA);
                response.getWriter().write(dm.getJSONView(new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir)), submittedTableName, filter));
            }
            catch (Exception e) {
                response.setStatus(401);
            }
        }
    }
}

