/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.core.ExtElement;
import com.gwtext.client.core.Function;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.MessageBox;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.Tool;
import org.gcube.application.aquamaps.aquamapsportlet.client.AdvancedGenerationPanel;
import org.gcube.application.aquamaps.aquamapsportlet.client.AquaMapsPortlet;
import org.gcube.application.aquamaps.aquamapsportlet.client.DiscoveringPanel;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.AquaMapsPortletCostants;
import org.gcube.application.aquamaps.aquamapsportlet.client.perturbation.EnvelopeGridsPanel;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.AquaMapsPortletLocalService;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.AquaMapsPortletLocalServiceAsync;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.AquaMapsPortletRemoteService;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.AquaMapsPortletRemoteServiceAsync;
import org.gcube.application.aquamaps.aquamapsportlet.client.selections.SmartAreaSelectionPanel;
import org.gcube.application.aquamaps.aquamapsportlet.client.selections.SpeciesSelectionPanel;
import org.gcube.portlets.widgets.guidedtour.client.GCUBEGuidedTour;
import org.gcube.portlets.widgets.guidedtour.client.types.ThemeColor;
import org.gcube.portlets.widgets.guidedtour.client.types.VerticalAlignment;
import org.gcube.portlets.widgets.guidedtour.shared.TourLanguage;

public class AquaMapsPortlet
implements EntryPoint {
    public static AquaMapsPortletLocalServiceAsync localService = (AquaMapsPortletLocalServiceAsync)GWT.create(AquaMapsPortletLocalService.class);
    public static AquaMapsPortletRemoteServiceAsync remoteService = (AquaMapsPortletRemoteServiceAsync)GWT.create(AquaMapsPortletRemoteService.class);
    private static AquaMapsPortlet singleton;
    private String sessionID = "";
    private static ServiceDefTarget localeEndpoint;
    private static ServiceDefTarget remoteEndpoint;
    private static final String tourImagesFolder = "tourImages/";
    private VerticalPanel mainLayout = new VerticalPanel();
    public TabPanel mainPanel;
    public DiscoveringPanel discoveringPanel;
    public AdvancedGenerationPanel advGeneration;
    public SpeciesSelectionPanel species;
    public SmartAreaSelectionPanel area;
    public EnvelopeGridsPanel envelopeCustomization;
    private RootPanel root;

    public AquaMapsPortlet() {
        this.sessionID = Cookies.getCookie((String)"JSESSIONID");
        localeEndpoint.setServiceEntryPoint(AquaMapsPortletCostants.AquaMapsPortletLocalImplUrl + ";jsessionid=" + this.sessionID);
        remoteEndpoint.setServiceEntryPoint(AquaMapsPortletCostants.AquaMapsPortletRemoteImplUrl + ";jsessionid=" + this.sessionID);
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public static AquaMapsPortlet get() {
        return singleton;
    }

    public void onModuleLoad() {
        this.root = RootPanel.get((String)"CommonGUIDIV_AM");
        singleton = this;
        DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onModuleLoad2() {
        AquaMapsPortletCostants.init();
        this.mainPanel = new TabPanel();
        this.discoveringPanel = new DiscoveringPanel();
        this.species = new SpeciesSelectionPanel();
        this.advGeneration = new AdvancedGenerationPanel();
        this.envelopeCustomization = new EnvelopeGridsPanel();
        Log.debug((String)"Starting creating layout");
        this.mainPanel.setWidth(1200);
        this.mainPanel.setHeight(800);
        this.mainPanel.setBorder(false);
        this.mainPanel.setId("AquaMainPanel");
        this.mainPanel.setTitle("Map Creation");
        this.mainPanel.setDeferredRender(false);
        this.mainPanel.add((Component)this.species);
        this.mainPanel.add((Component)this.envelopeCustomization);
        this.mainPanel.add((Component)this.advGeneration);
        this.mainPanel.add((Component)this.discoveringPanel);
        Log.trace((String)"Layout created");
        this.mainLayout.add((Widget)this.mainPanel);
        Log.trace((String)"Div found, we are on portlet");
        this.root.add((Widget)this.mainLayout);
        Window.addResizeHandler((ResizeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.updateSize();
        this.mainPanel.hideTabStripItem((Panel)this.envelopeCustomization);
        this.showGuidedTour();
    }

    public void updateSize() {
        Log.trace((String)"Updating size..");
        RootPanel workspace = RootPanel.get((String)"CommonGUIDIV_AM");
        int topBorder = workspace.getAbsoluteTop();
        int leftBorder = workspace.getAbsoluteLeft();
        int rightScrollBar = 17;
        int rootHeight = Window.getClientHeight() - topBorder - 4;
        int rootWidth = Window.getClientWidth() - 2 * leftBorder - rightScrollBar;
        Log.trace((String)("New  dimension Height: " + rootHeight + " Width: " + rootWidth));
        this.mainLayout.setHeight(rootHeight + "");
        this.mainLayout.setWidth(rootWidth + "");
        this.printData();
    }

    protected void printData() {
        Log.trace((String)("Client Height: " + Window.getClientHeight()));
        Log.trace((String)("Client Width: " + Window.getClientWidth()));
        Log.trace((String)("Absolute Left: " + RootPanel.get((String)"CommonGUIDIV_AM").getAbsoluteLeft()));
        Log.trace((String)("Absolute Top: " + RootPanel.get((String)"CommonGUIDIV_AM").getAbsoluteTop()));
        Log.trace((String)("Offset Height: " + RootPanel.get((String)"CommonGUIDIV_AM").getOffsetHeight()));
        Log.trace((String)("Offset Width: " + RootPanel.get((String)"CommonGUIDIV_AM").getOffsetWidth()));
        this.hideLoading(this.mainPanel.getId());
    }

    public void showLoading(String message, String elementId) {
        try {
            ExtElement element = Ext.get((String)elementId);
            if (element != null && element.isVisible()) {
                element.mask(message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hideLoading(String elementId) {
        try {
            ExtElement element = Ext.get((String)elementId);
            if (element != null && element.isMasked()) {
                element.unmask();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void notifyError(String msg) {
        MessageBox.alert((String)msg);
    }

    public void showMessage(String msg) {
        MessageBox.alert((String)msg);
    }

    public Tool getHelpTool(String url) {
        return new Tool(Tool.HELP, (Function)new /* Unavailable Anonymous Inner Class!! */, "Click to open related wiki page");
    }

    private void showGuidedTour() {
        GCUBEGuidedTour gt = new GCUBEGuidedTour("Maps Generation", AquaMapsPortlet.class.getName(), "https://gcube.wiki.gcube-system.org/gcube/index.php/AquaMaps", 800, 400, false, ThemeColor.BLUE, new TourLanguage[]{TourLanguage.EN});
        4 introStep = new /* Unavailable Anonymous Inner Class!! */;
        introStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)introStep);
        5 speciesFilteringStep = new /* Unavailable Anonymous Inner Class!! */;
        speciesFilteringStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)speciesFilteringStep);
        6 customizationStep = new /* Unavailable Anonymous Inner Class!! */;
        customizationStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)customizationStep);
        7 mapsSettingsStep = new /* Unavailable Anonymous Inner Class!! */;
        mapsSettingsStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)mapsSettingsStep);
        8 submittedGrid = new /* Unavailable Anonymous Inner Class!! */;
        submittedGrid.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)submittedGrid);
        9 detailsStep = new /* Unavailable Anonymous Inner Class!! */;
        detailsStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)detailsStep);
        10 gisStep = new /* Unavailable Anonymous Inner Class!! */;
        gisStep.setTextVerticalAlignment(VerticalAlignment.ALIGN_MIDDLE);
        gt.addStep((Composite)gisStep);
        gt.openTour();
    }

    static {
        localeEndpoint = (ServiceDefTarget)localService;
        remoteEndpoint = (ServiceDefTarget)remoteService;
    }
}

