/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.CustomServlet;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBManager;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.utils.Utils;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.model.PagedRequestSettings;
import org.gcube.application.aquamaps.aquamapsservice.stubs.fw.types.OrderDirection;
import org.gcube.application.framework.core.session.ASLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionServlet
extends CustomServlet {
    private static final Logger logger = LoggerFactory.getLogger(SelectionServlet.class);
    private static final long serialVersionUID = 7237729162027277043L;

    protected void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block15: {
            String requested = request.getParameter("selection");
            try {
                ASLSession session = Utils.getSession((HttpSession)request.getSession());
                if (requested != null) {
                    int startIndex = 0;
                    int limit = 100;
                    try {
                        startIndex = Integer.parseInt(request.getParameter("start"));
                        limit = Integer.parseInt(request.getParameter("limit"));
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    String sortColumn = request.getParameter("sort");
                    String sortDir = request.getParameter("dir");
                    if (sortColumn == null) {
                        sortColumn = SpeciesFields.speciesid + "";
                    }
                    if (sortDir == null) {
                        sortDir = "ASC";
                    }
                    response.setContentType("application/json; charset=utf-8");
                    response.setStatus(200);
                    if (requested.equals("selectedSpecies")) {
                        String aquamapsObjectTitle = request.getParameter("aquamaps_title");
                        String aquamapsObjectId = request.getParameter("aquamaps_id");
                        if (aquamapsObjectTitle != null) {
                            response.getWriter().write(DBManager.getInstance((String)session.getScope()).getObjectJSONBasket(session.getUsername(), aquamapsObjectTitle, startIndex, limit, sortColumn, sortDir));
                        } else if (aquamapsObjectId != null) {
                            int id = Integer.parseInt(request.getParameter("aquamaps_id"));
                            response.getWriter().write(DBManager.getInstance((String)session.getScope()).getFetchedJSONBasket(id, startIndex, limit, sortColumn, sortDir));
                        } else {
                            response.getWriter().write(DBManager.getInstance((String)session.getScope()).getUserJSONBasket(session.getUsername(), startIndex, limit, sortColumn, sortDir));
                        }
                    } else if (requested.equals("selectedAreas")) {
                        response.getWriter().write(DBManager.getInstance((String)session.getScope()).getJSONAreaSelection(session.getUsername(), new PagedRequestSettings(limit, startIndex, sortColumn, OrderDirection.valueOf((String)sortDir))));
                    } else {
                        response.setStatus(417);
                    }
                    break block15;
                }
                response.setStatus(417);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unexpected Exception", (Throwable)e);
                response.setStatus(401);
            }
        }
    }
}

