/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.client.filters;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.grid.event.EditorGridListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.FitLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;
import java.util.ArrayList;
import org.gcube.application.aquamaps.aquamapsportlet.client.AquaMapsPortlet;
import org.gcube.application.aquamaps.aquamapsportlet.client.RecordDefinitions;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFieldType;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFilterType;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.FilterSummary;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.MinMaxGrid;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.PhylogenyComboBox;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.SearchByKeywordsGrid;
import org.gcube.application.aquamaps.aquamapsportlet.client.filters.TrueFalseGrid;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.Callbacks;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientField;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientFilter;

public class SpeciesFilter
extends FormPanel {
    PhylogenyComboBox kingdomSelector = new PhylogenyComboBox(SpeciesFields.kingdom + "", "Kingdom", RecordDefinitions.kingdomRecordDef);
    PhylogenyComboBox phylumSelector = new PhylogenyComboBox(SpeciesFields.phylum + "", "Phylum", RecordDefinitions.phylumRecordDef);
    PhylogenyComboBox classSelector = new PhylogenyComboBox(SpeciesFields.classcolumn + "", "Class", RecordDefinitions.classRecordDef);
    PhylogenyComboBox orderSelector = new PhylogenyComboBox(SpeciesFields.ordercolumn + "", "Order", RecordDefinitions.orderRecordDef);
    PhylogenyComboBox familySelector = new PhylogenyComboBox(SpeciesFields.familycolumn + "", "Family", RecordDefinitions.familyRecordDef);
    final MinMaxGrid minMax = new MinMaxGrid("Min/Max values");
    final TrueFalseGrid trueFalse = new TrueFalseGrid("Additional Criteria");
    SearchByKeywordsGrid nameFilters;
    SearchByKeywordsGrid codeFilters;
    final FieldSet comboBoxes = new FieldSet();
    final FieldSet names = new FieldSet();
    final FieldSet codes = new FieldSet();
    ToolbarButton apply = new ToolbarButton("Apply Filter");
    ToolbarButton clear = new ToolbarButton("Clear Filters");
    ToolbarButton toggleDetails = new ToolbarButton("Show Active Filters Summary");
    public FilterSummary filterDetails = new FilterSummary();

    public SpeciesFilter() {
        this.setTitle("Search/Filter By");
        this.setLayout((ContainerLayout)new VerticalLayout(1));
        this.setAutoScroll(true);
        this.setBorder(true);
        this.kingdomSelector.linkToComboBox(this.phylumSelector);
        this.kingdomSelector.linkToComboBox(this.classSelector);
        this.kingdomSelector.linkToComboBox(this.orderSelector);
        this.kingdomSelector.linkToComboBox(this.familySelector);
        this.phylumSelector.linkToComboBox(this.classSelector);
        this.phylumSelector.linkToComboBox(this.orderSelector);
        this.phylumSelector.linkToComboBox(this.familySelector);
        this.classSelector.linkToComboBox(this.orderSelector);
        this.classSelector.linkToComboBox(this.familySelector);
        this.orderSelector.linkToComboBox(this.familySelector);
        this.comboBoxes.setTitle("Phylogeny");
        this.comboBoxes.add((Component)this.kingdomSelector);
        this.comboBoxes.add((Component)this.phylumSelector);
        this.comboBoxes.add((Component)this.classSelector);
        this.comboBoxes.add((Component)this.orderSelector);
        this.comboBoxes.add((Component)this.familySelector);
        this.comboBoxes.setCollapsible(true);
        this.comboBoxes.collapse();
        this.comboBoxes.setAutoHeight(true);
        this.comboBoxes.add((Widget)new HTMLPanel("<p> Taxonomic classification follows  <a href=\"http://www.catalogueoflife.org/\" target=\"_blank\">Catalogue of Life</a> classification.</p>"));
        this.comboBoxes.setWidth(340);
        String[] nameFilter = new String[]{SpeciesFields.scientific_name + "", SpeciesFields.genus + "", SpeciesFields.species + "", SpeciesFields.fbname + ""};
        this.nameFilters = new SearchByKeywordsGrid("Species Name", nameFilter, false);
        this.names.setTitle("Name Filter");
        this.names.setCollapsible(true);
        this.names.collapse();
        this.names.setLayout((ContainerLayout)new FitLayout());
        this.names.setAutoHeight(true);
        this.names.setAutoWidth(false);
        this.names.setWidth(340);
        this.names.add((Component)this.nameFilters);
        String[] codeFilter = new String[]{SpeciesFields.speciesid + ""};
        this.codeFilters = new SearchByKeywordsGrid("Code", codeFilter, true);
        this.codes.setTitle("Code Filter");
        this.codes.setCollapsible(true);
        this.codes.collapse();
        this.codes.setLayout((ContainerLayout)new FitLayout());
        this.codes.setAutoHeight(true);
        this.codes.setAutoWidth(false);
        this.codes.setWidth(340);
        this.codes.add((Component)this.codeFilters);
        this.codeFilters.addEditorGridListener((EditorGridListener)new /* Unavailable Anonymous Inner Class!! */);
        this.nameFilters.addEditorGridListener((EditorGridListener)new /* Unavailable Anonymous Inner Class!! */);
        this.add((Component)this.names);
        this.add((Component)this.comboBoxes);
        this.add((Component)this.trueFalse);
        this.add((Component)this.minMax);
        this.add((Component)this.codes);
        this.filterDetails.hide();
        this.add((Component)this.filterDetails);
        this.setBottomToolbar(new Button[]{this.apply, this.clear, this.toggleDetails});
        this.apply.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.clear.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toggleDetails.setEnableToggle(true);
        this.toggleDetails.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public ClientField returnSelectedPhylogeny() {
        ClientField toReturn;
        if (this.familySelector.getValue() != null) {
            toReturn = new ClientField();
            toReturn.setName(SpeciesFields.familycolumn + "");
            toReturn.setValue(this.familySelector.getValue());
            toReturn.setType(ClientFieldType.STRING);
        } else if (this.orderSelector.getValue() != null) {
            toReturn = new ClientField();
            toReturn.setName(SpeciesFields.ordercolumn + "");
            toReturn.setValue(this.orderSelector.getValue());
            toReturn.setType(ClientFieldType.STRING);
        } else if (this.classSelector.getValue() != null) {
            toReturn = new ClientField();
            toReturn.setName(SpeciesFields.classcolumn + "");
            toReturn.setValue(this.classSelector.getValue());
            toReturn.setType(ClientFieldType.STRING);
        } else if (this.phylumSelector.getValue() != null) {
            toReturn = new ClientField();
            toReturn.setName(SpeciesFields.phylum + "");
            toReturn.setValue(this.phylumSelector.getValue());
            toReturn.setType(ClientFieldType.STRING);
        } else if (this.kingdomSelector.getValue() != null) {
            toReturn = new ClientField();
            toReturn.setName(SpeciesFields.kingdom + "");
            toReturn.setValue(this.kingdomSelector.getValue());
            toReturn.setType(ClientFieldType.STRING);
        } else {
            toReturn = null;
        }
        return toReturn;
    }

    public void applyFiltering() {
        AquaMapsPortlet.get().showLoading("Sending Filter Information", AquaMapsPortlet.get().species.toAddSpecies.getId());
        ArrayList<ClientFilter> filter = new ArrayList<ClientFilter>();
        ClientField taxField = this.returnSelectedPhylogeny();
        if (taxField != null) {
            ClientFilter taxoFilter = new ClientFilter();
            taxoFilter.setType(ClientFilterType.is);
            taxoFilter.setField(taxField);
            filter.add(taxoFilter);
        }
        try {
            filter.addAll(this.minMax.getFilter());
            filter.addAll(this.trueFalse.getFilter());
        }
        catch (Exception e) {
            Log.error((String)"Exception while parsing characteristic Filter", (Throwable)e);
        }
        filter.addAll(this.nameFilters.getFilter());
        filter.addAll(this.codeFilters.getFilter());
        AquaMapsPortlet.localService.setSpeciesFilter(filter, this.filterDetails.getJSON(), Callbacks.setSpeciesFilterCallback);
    }
}

