/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.aquamaps.aquamapsportlet.servlet.db;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.AreaFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.LocalObjectFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.fields.SpeciesFields;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientFieldType;
import org.gcube.application.aquamaps.aquamapsportlet.client.constants.types.ClientObjectType;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientField;
import org.gcube.application.aquamaps.aquamapsportlet.client.rpc.data.ClientObject;
import org.gcube.application.aquamaps.aquamapsportlet.servlet.db.DBSession;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.enhanced.Area;
import org.gcube.application.aquamaps.aquamapsservice.stubs.datamodel.types.AreaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DBUtil {
    private static final Logger log = LoggerFactory.getLogger(DBSession.class);
    protected static final String[] speciesFields = new String[]{SpeciesFields.speciesid + "", SpeciesFields.genus + "", SpeciesFields.species + "", SpeciesFields.speccode + "", SpeciesFields.fbname + "", SpeciesFields.scientific_name + "", SpeciesFields.occurrecs + "", SpeciesFields.occurcells + "", SpeciesFields.classcolumn + "", SpeciesFields.familycolumn + "", SpeciesFields.kingdom + "", SpeciesFields.ordercolumn + "", SpeciesFields.phylum + "", SpeciesFields.map_beforeafter + "", SpeciesFields.map_seasonal + "", SpeciesFields.with_gte_5 + "", SpeciesFields.with_gte_6 + "", SpeciesFields.with_gt_66 + "", SpeciesFields.no_of_cells_3 + "", SpeciesFields.no_of_cells_5 + "", SpeciesFields.no_of_cells_0 + "", SpeciesFields.database_id + "", SpeciesFields.picname + "", SpeciesFields.authname + "", SpeciesFields.entered + "", SpeciesFields.total_native_csc_cnt + "", SpeciesFields.deepwater + "", SpeciesFields.m_mammals + "", SpeciesFields.angling + "", SpeciesFields.diving + "", SpeciesFields.dangerous + "", SpeciesFields.m_invertebrates + "", SpeciesFields.algae + "", SpeciesFields.seabirds + "", SpeciesFields.timestampcolumn + "", SpeciesFields.pic_source_url + "", SpeciesFields.freshwater + ""};
    protected static final int[] speciesFieldsType = new int[]{12, 12, 12, 4, 12, 12, 4, 4, 12, 12, 12, 12, 12, 8, 8, 5, 5, 5, 4, 4, 4, 4, 12, 12, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 93, 12, 5};

    public static String getOuterName(String dbType) {
        if (dbType.equalsIgnoreCase("Class")) {
            return SpeciesFields.classcolumn + "";
        }
        if (dbType.equalsIgnoreCase("Kingdom")) {
            return SpeciesFields.kingdom + "";
        }
        if (dbType.equalsIgnoreCase("Phylum")) {
            return SpeciesFields.phylum + "";
        }
        if (dbType.equalsIgnoreCase("Order_column")) {
            return SpeciesFields.ordercolumn + "";
        }
        if (dbType.equalsIgnoreCase("Order_table")) {
            return SpeciesFields.ordercolumn + "";
        }
        if (dbType.equalsIgnoreCase("Family")) {
            return SpeciesFields.familycolumn + "";
        }
        for (String specField : speciesFields) {
            if (!dbType.equalsIgnoreCase(specField)) continue;
            return specField;
        }
        return dbType.toLowerCase();
    }

    public static String toJSon(ResultSet resultSet) throws SQLException {
        try {
            StringBuilder json = new StringBuilder();
            json.append("{\"data\":[");
            ResultSetMetaData metaData = null;
            int numberOfColumns = 0;
            int row = 0;
            while (resultSet.next()) {
                if (metaData == null) {
                    metaData = resultSet.getMetaData();
                    numberOfColumns = metaData.getColumnCount();
                }
                if (row > 0) {
                    json.append(",{");
                } else {
                    json.append('{');
                }
                for (int column = 1; column <= numberOfColumns; ++column) {
                    if (column > 1) {
                        json.append(',');
                    }
                    json.append(DBUtil.quote((String)DBUtil.getOuterName((String)metaData.getColumnName(column))));
                    json.append(':');
                    json.append(DBUtil.quote((String)resultSet.getString(column)));
                }
                json.append('}');
                ++row;
            }
            json.append("],\"totalcount\":");
            json.append(row);
            json.append("}");
            return json.toString();
        }
        catch (Exception e) {
            log.error("Result Set Might Be Empty ... returning empty JSON String...");
            log.trace("" + e);
            return "{\"data\":[],\"totalcount\":0}";
        }
    }

    protected static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String toJSon(ResultSet resultSet, int start, int end) throws SQLException {
        try {
            StringBuilder json = new StringBuilder();
            json.append("{\"data\":[");
            ResultSetMetaData metaData = null;
            int numberOfColumns = 0;
            int row = 0;
            while (resultSet.next()) {
                if (metaData == null) {
                    metaData = resultSet.getMetaData();
                    numberOfColumns = metaData.getColumnCount();
                }
                if (row >= start && row <= end) {
                    if (row - start > 0) {
                        json.append(",{");
                    } else {
                        json.append('{');
                    }
                    for (int column = 1; column <= numberOfColumns; ++column) {
                        if (column > 1) {
                            json.append(',');
                        }
                        json.append(DBUtil.quote((String)DBUtil.getOuterName((String)metaData.getColumnName(column))));
                        json.append(':');
                        json.append(DBUtil.quote((String)resultSet.getString(column)));
                    }
                    json.append('}');
                }
                ++row;
            }
            json.append("],\"totalcount\":");
            json.append(row);
            json.append("}");
            return json.toString();
        }
        catch (Exception e) {
            log.error("Result Set Might Be Empty ... returning empty JSON String...");
            log.trace("" + e);
            return "{\"data\":[],\"totalcount\":0}";
        }
    }

    static String getAreaQuery(String table, boolean includeFAO, boolean includeEEZ, boolean includeLME) {
        String areaFilter;
        String string = areaFilter = includeFAO ? " type = '" + AreaType.FAO + "' " : "";
        if (includeEEZ) {
            areaFilter = areaFilter + (includeFAO ? " OR " : "") + " type = '" + AreaType.EEZ + "' ";
        }
        if (includeLME) {
            areaFilter = areaFilter + (includeFAO || includeEEZ ? " OR " : "") + " type = '" + AreaType.LME + "' ";
        }
        return "SELECT * FROM " + table + " WHERE " + areaFilter;
    }

    static List<Area> loadAreas(ResultSet rs) throws Exception {
        ArrayList<Area> toReturn = new ArrayList<Area>();
        try {
            while (rs.next()) {
                toReturn.add(new Area(AreaType.valueOf((String)rs.getString(AreaFields.type + "")), rs.getString(AreaFields.code + ""), rs.getString(AreaFields.name + "")));
            }
        }
        catch (Exception e) {
            log.error("Result Set Might Be Empty ... returning empty Area list ...");
            log.trace("" + e);
        }
        return toReturn;
    }

    static List<ClientObject> loadObjects(ResultSet rs) throws Exception {
        ArrayList<ClientObject> toReturn = new ArrayList<ClientObject>();
        try {
            while (rs.next()) {
                ClientObject obj = new ClientObject();
                obj.setAuthor(rs.getString("userid"));
                obj.getBoundingBox().parse(rs.getString(LocalObjectFields.bbox + ""));
                obj.setGis(Boolean.valueOf(rs.getInt(LocalObjectFields.gis + "") == 1));
                obj.setName(rs.getString(LocalObjectFields.title + ""));
                obj.setType(ClientObjectType.valueOf((String)rs.getString(LocalObjectFields.type + "")));
                obj.setThreshold(Float.valueOf(rs.getFloat(LocalObjectFields.threshold + "")));
                obj.setSelectedSpecies(new ClientField(LocalObjectFields.species + "", rs.getString(LocalObjectFields.species + ""), obj.getType().equals((Object)ClientObjectType.Biodiversity) ? ClientFieldType.INTEGER : ClientFieldType.STRING));
                toReturn.add(obj);
            }
        }
        catch (Exception e) {
            log.error("Result Set Might Be Empty ... returning empty Object list ...");
            log.trace("" + e);
        }
        return toReturn;
    }
}

