function createInteractiveFilterLayerWMS(geoserverWmspath, workspace, layername, slidebarID, dateColumnName, startDateString, endDateString){

//	OpenLayers.ProxyHost = "http://localhost:8080/geoserver/rest/proxy?url=";
//	OpenLayers.ProxyHost = "/geoserver/rest/proxy?url=";
	
	var startDateTimestamp = Date.parse(startDateString);
	var endDateTimestamp = Date.parse(endDateString);
	
	/*
	 //need to be edited in order to work
	var filter = new OpenLayers.Filter.Comparison({
		type: OpenLayers.Filter.Comparison.EQUAL_TO,
		value: "Sat June 07 1930 21:00:00 GMT+0300 (EEST)",
//        type: OpenLayers.Filter.Comparison.BETWEEN,
        property: dateColumnName
//        lowerBoundary: "Sat June 07 1930 21:00:00 GMT+0300 (EEST)",//new Date(startDateString),
//        upperBoundary: "Sat June 07 2008 21:00:00 GMT+0300 (EEST)"//new Date(endDateString)
    });
	var filter_1_0 = new OpenLayers.Format.Filter({version: "1.0.0"});
    var xml = new OpenLayers.Format.XML(); 
    var preencoded = filter_1_0.write(filter);
    var filter_param = xml.write(preencoded);
	
	*/	
	var wmsLayer = new OpenLayers.Layer.WMS(
			layername,
			geoserverWmspath,
            {
                layers: workspace+":"+layername,
                format: 'image/png',
                transparent: true
            }, 
            {
            	isBaseLayer: false,
                opacity: 1
//                singleTile: true
            }
    );

	
	wmsLayer.dateColumnName = dateColumnName;
	
	$(document.body).append("<div id='"+slidebarID+"container'></div>");
	$(document.body).append("<div id="+slidebarID+"></div>");
	
	
	var VisSelectID = slidebarID+"VisSel";
	var visSelHTML = "<select id='"+VisSelectID+"'><option value='nav'>Navigation</option><option value='vis'>Multiselect and Visualise</option></select>";
	if($("#"+VisSelectID).length==0){
		$(document.body).append(visSelHTML);
	}
	
	
	
	var slider = $("#"+slidebarID);
	
	var container = $("#"+slidebarID+"container");
	
	container.css("position","absolute"); //if this creates trouble, comment it out
	
	$(function() {
		slider.slider({
			range : true,
			min : startDateTimestamp,
			max : endDateTimestamp,
			values : [startDateTimestamp, endDateTimestamp ],
			start: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
		    },
			slide : function(event, ui) {
				var lowDate = new Date(ui.values[0]);
				var highDate = new Date(ui.values[1]);
//				console.log("Low ts: "+ui.values[0]+"\tHigh ts"+ui.values[1]+"Low date: "+lowDate.toDateString()+"\tHigh date"+highDate.toDateString());			
		        ($("#"+slidebarID+" a:first")).tooltip({content:lowDate.toDateString(),track: true});
		        ($("#"+slidebarID+" a:last")).tooltip({content:highDate.toDateString(),track: true});
		        
			},
			stop: function(event,ui){
				($("#"+slidebarID)).slider().find(".ui-slider-handle").attr("title", "");
				var lowDate = new Date(ui.values[0]);
				var highDate = new Date(ui.values[1]);
				var CQL_FILTER = dateColumnName+" during "+dateCQLReady(lowDate)+"/"+dateCQLReady(highDate)+ " and "+dateColumnName+" is not null";
				wmsLayer.mergeNewParams({'CQL_FILTER': CQL_FILTER});
				($("#"+slidebarID+" a:first")).tooltip();
		        ($("#"+slidebarID+" a:last")).tooltip();
//		        console.log("CQL_FILTER="+ CQL_FILTER);
		    },
		    create: function(event, ui){
				//set the filter to show only features within the filtered period by setting the cql value
				var CQL_FILTER = dateColumnName+" during "+dateCQLReady(new Date(startDateTimestamp))+"/"+dateCQLReady(new Date(endDateTimestamp))+ " and "+dateColumnName+" is not null";
				wmsLayer.mergeNewParams({'CQL_FILTER': CQL_FILTER});
		    }
		});
		
	    slider.slider().find(".ui-slider-handle").attr("title", "");

	    ($("#"+slidebarID+" a:first")).tooltip({
		    content:(new Date(startDateTimestamp)).toDateString(),
			track: true
    	});
    
	    ($("#"+slidebarID+" a:last")).tooltip({
    		content:(new Date(endDateTimestamp)).toDateString(),
    		track: true
    	});
	    
	});	
	
	
	$("#"+slidebarID).click(function(e) {e.stopPropagation();});
	$("#"+slidebarID).dblclick(function(e) {e.stopPropagation();});
	$("#"+slidebarID).mousedown(function(e) {e.stopPropagation();});
	
	$("#"+VisSelectID).click(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).dblclick(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).mousedown(function(e) {e.stopPropagation();});
	$("#"+VisSelectID).hide();
	
	
	$("#"+slidebarID+"container").append(document.getElementById(slidebarID));
	$("#"+slidebarID+"container").append(document.getElementById(VisSelectID));
	wmsLayer.div.appendChild(document.getElementById(slidebarID+"container"));
	
	
	
	wmsLayer.events.register("move",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wmsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	wmsLayer.events.register("moveend",this,function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wmsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
	});
	
	
	wmsLayer.events.register("loadstart", this, function(){
		var wPerc = 0.95; //width percentage
		var mapWidth = wmsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);
	});
	
	wmsLayer.events.register("loadend", this, function(){
		container.css("z-index",$("#layerSlidercontainer").parent().parent().css("z-index"));
		var wPerc = 0.95; //width percentage
		var mapWidth = wmsLayer.map.getSize().w; //map width in pixels
		container.offset({"top":slider.height()+2,"left":(mapWidth*(1-wPerc))/1.5});
		container.css('width', wPerc*mapWidth);		
	});
		
	return wmsLayer;
}


//get date into a cql-ready string
function dateCQLReady(date){
	var month = String(date.getMonth()+1).length==1?"0"+String(date.getMonth()+1):String(date.getMonth()+1);
	var day = String(date.getDate()).length==1?"0"+String(date.getDate()):String(date.getDate());
	return date.getFullYear()+"-"+month+"-"+day+"T00:00:00Z";
}

