package org.visualisation.client;


import java.util.Date;

import org.gwtopenmaps.openlayers.client.OpenLayersEObjectWrapper;
import org.gwtopenmaps.openlayers.client.control.Control;
import org.gwtopenmaps.openlayers.client.control.ControlOptions;
import org.gwtopenmaps.openlayers.client.event.ControlActivateListener;
import org.gwtopenmaps.openlayers.client.geometry.Point;
import org.gwtopenmaps.openlayers.client.layer.Layer;
import org.gwtopenmaps.openlayers.client.util.JSObject;

import com.google.gwt.core.client.JsDate;
import com.google.gwt.user.client.Element;

public class OpenLayers extends OpenLayersEObjectWrapper {

	protected OpenLayers(JSObject openLayersObject) {
		super(openLayersObject);
	}

	
	/**
	 * creates an empty layer with some controls on top ! 
	 * @param serverWmspath the geoserver url
	 * @param workspace the workspace within the layer resides
	 * @param layerName the layer name
	 * @param slidebarID an ID (html) for the slidebar of the layer (it could be same as the layer name)
	 * @param dateColumnName  the Date field name of the layer by which the time filtering will be done.
	 * @param startDate  a "from" date as earlier limit for the filtering slider
	 * @param endDate  a "to" date as the upper limit for the filtering slider
	 * @return org.gwtopenmaps.openlayers.client.layer.Layer
	 */
	public static Layer createInteractiveFilterLayerWMS(String serverWmspath, String workspace, String layerName, String slidebarID, String dateColumnName, Date startDate, Date endDate) {
		JSObject jsObject = createInteractiveFilterLayerWMSN(
				serverWmspath, 
				workspace, 
				layerName, 
				slidebarID,
				dateColumnName,
				startDate.toGMTString(),
				endDate.toGMTString()
		);
		Layer layer = Layer.narrowToLayer(jsObject);
		return layer;
	}
	
	private static native JSObject createInteractiveFilterLayerWMSN(String serverWmspath, String workspace, String layerName, String slidebarID, String dateColumnName, String startDate, String endDate)//JsDate startDate, JsDate endDate) 
	/*-{
		var interactiveLayer = $wnd.createInteractiveFilterLayerWMS(serverWmspath, workspace, layerName, slidebarID, dateColumnName, startDate, endDate);
		return (interactiveLayer === undefined) ? null : interactiveLayer;
	}-*/;
	
	
	
	public static Control createWMSFeatureControl(Layer layer) {
		JSObject jsObject = createWMSFeatureControlN(layer.getJSObject());
		Control featureControl = Control.narrowToControl(jsObject);
		return featureControl;
	}
	
	private static native JSObject createWMSFeatureControlN(JSObject layer)
	/*-{
		var control = $wnd.createWMSFeatureControl(layer);
		return (control === undefined) ? null : control;
	}-*/;
	

	
	public static Layer createInteractiveFilterLayerWFS(String serverWfspath, String workspace, String layerName, String slidebarID, String dateColumnName, Date startDate, Date endDate) {
		JSObject jsObject = createInteractiveFilterLayerWFSN(
				serverWfspath, 
				workspace, 
				layerName, 
				slidebarID,
				dateColumnName,
				startDate.toGMTString(),
				endDate.toGMTString()
		);
		Layer layer = Layer.narrowToLayer(jsObject);
		return layer;
	}
	
	private static native JSObject createInteractiveFilterLayerWFSN(String serverWfspath, String workspace, String layerName, String slidebarID, String dateColumnName, String startDate, String endDate)//JsDate startDate, JsDate endDate) 
	/*-{
		var interactiveLayer = $wnd.createInteractiveFilterLayerWFS(serverWfspath, workspace, layerName, slidebarID, dateColumnName, startDate, endDate);
		return (interactiveLayer === undefined) ? null : interactiveLayer;
	}-*/;
	
	public static Control createWFSFeatureControl(Layer layer) {
		JSObject jsObject = createWFSFeatureControlN(layer.getJSObject());
		Control featureControl = Control.narrowToControl(jsObject);
		return featureControl;
	}
	
	private static native JSObject createWFSFeatureControlN(JSObject layer)
	/*-{
		var control = $wnd.createWFSFeatureControl(layer);
		return (control === undefined) ? null : control;
	}-*/;
	
	public static Layer createInteractiveCatchLayer(String serverWMSpath, String serverWFSpath, String workspaceCountries, String layerNameCountries, String workspaceCatches, String layerNameCatches, String slidebarID, String dateColumnName, int startYear, int endYear) {
		JSObject jsObject = createInteractiveCatchLayerN(
				serverWMSpath,
				serverWFSpath, 
				workspaceCountries, 
				layerNameCountries,
				workspaceCatches,
				layerNameCatches,
				slidebarID,
				dateColumnName,
				startYear,
				endYear
		);
		Layer layer = Layer.narrowToLayer(jsObject);
		return layer;
	}
	
	private static native JSObject createInteractiveCatchLayerN(String serverWMSpath, String serverWFSpath, String workspaceCountries, String layerNameCountries, String workspaceCatches, String layerNameCatches, String slidebarID, String dateColumnName, int startYear, int endYear) 
	/*-{
		var interactiveLayer = $wnd.createInteractiveCatchLayer(serverWMSpath, serverWFSpath, workspaceCountries, layerNameCountries, workspaceCatches, layerNameCatches, slidebarID, dateColumnName, startYear, endYear);
		return (interactiveLayer === undefined) ? null : interactiveLayer;
	}-*/;
	

}

