/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache.memcached;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import net.spy.memcached.CASResponse;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheEntrySerializer;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.DefaultHttpCacheEntrySerializer;

public class MemcachedHttpCacheStorage
implements HttpCacheStorage {
    private final MemcachedClientIF client;
    private final HttpCacheEntrySerializer serializer;
    private final int maxUpdateRetries;

    public MemcachedHttpCacheStorage(InetSocketAddress address) throws IOException {
        this((MemcachedClientIF)new MemcachedClient(new InetSocketAddress[]{address}));
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF cache) {
        this(cache, new CacheConfig(), new DefaultHttpCacheEntrySerializer());
    }

    public MemcachedHttpCacheStorage(MemcachedClientIF client, CacheConfig config, HttpCacheEntrySerializer serializer) {
        this.client = client;
        this.maxUpdateRetries = config.getMaxUpdateRetries();
        this.serializer = serializer;
    }

    public void putEntry(String url, HttpCacheEntry entry) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.serializer.writeTo(entry, bos);
        this.client.set(url, 0, (Object)bos.toByteArray());
    }

    public HttpCacheEntry getEntry(String url) throws IOException {
        byte[] data = (byte[])this.client.get(url);
        if (null == data) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return this.serializer.readFrom(bis);
    }

    public void removeEntry(String url) throws IOException {
        this.client.delete(url);
    }

    public void updateEntry(String url, HttpCacheUpdateCallback callback) throws HttpCacheUpdateException, IOException {
        int numRetries = 0;
        do {
            CASValue v;
            byte[] oldBytes = (v = this.client.gets(url)) != null ? (byte[])v.getValue() : null;
            HttpCacheEntry existingEntry = null;
            if (oldBytes != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(oldBytes);
                existingEntry = this.serializer.readFrom(bis);
            }
            HttpCacheEntry updatedEntry = callback.update(existingEntry);
            if (v == null) {
                this.putEntry(url, updatedEntry);
                return;
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.serializer.writeTo(updatedEntry, bos);
            CASResponse casResult = this.client.cas(url, v.getCas(), (Object)bos.toByteArray());
            if (casResult != CASResponse.OK) continue;
            return;
        } while (++numRetries <= this.maxUpdateRetries);
        throw new HttpCacheUpdateException("Failed to update");
    }
}

