/*
 * Decompiled with CFR 0.152.
 */
package org.ektorp.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.ektorp.util.Predicate;

public class ReflectionUtils {
    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass, Predicate<Field> p) {
        for (Field f : clazz.getDeclaredFields()) {
            T a = f.getAnnotation(annotationClass);
            if (!(a != null & p.apply(f))) continue;
            return a;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.findAnnotation(clazz.getSuperclass(), annotationClass, p);
        }
        return null;
    }

    public static Collection<Field> eachField(Class<?> clazz, Predicate<Field> p) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field f : clazz.getDeclaredFields()) {
            if (!p.apply(f)) continue;
            result.add(f);
        }
        if (clazz.getSuperclass() != null) {
            result.addAll(ReflectionUtils.eachField(clazz.getSuperclass(), p));
        }
        return result;
    }

    public static Collection<Method> eachMethod(Class<?> clazz, Predicate<Method> p) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method f : clazz.getDeclaredMethods()) {
            if (!p.apply(f)) continue;
            result.add(f);
        }
        if (clazz.getSuperclass() != null) {
            result.addAll(ReflectionUtils.eachMethod(clazz.getSuperclass(), p));
        }
        return result;
    }

    public static <T extends Annotation> void eachAnnotation(Class<?> clazz, Class<T> annotationClass, Predicate<T> p) {
        T a = clazz.getAnnotation(annotationClass);
        if (a != null) {
            p.apply(a);
        }
        for (Method me : clazz.getDeclaredMethods()) {
            a = me.getAnnotation(annotationClass);
            if (a == null) continue;
            p.apply(a);
        }
        if (clazz.getSuperclass() != null) {
            ReflectionUtils.eachAnnotation(clazz.getSuperclass(), annotationClass, p);
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        for (Method me : clazz.getDeclaredMethods()) {
            if (!me.getName().equalsIgnoreCase(name)) continue;
            return me;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectionUtils.findMethod(clazz.getSuperclass(), name);
        }
        return null;
    }

    public static boolean hasAnnotation(AnnotatedElement e, Class<? extends Annotation> annotationClass) {
        return e.getAnnotation(annotationClass) != null;
    }

    public static interface AnnotationPredicate {
        public boolean equals(Method var1, Annotation var2);
    }
}

