

package org.gcube.accounting.datamodel.serialization;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.gcube.accounting.datamodel.Property;

/**
 * 
 * The XmlAdapter<ValueType, BoundType> class is responsible for converting
 * between instances of the unmappable and mappable classes. The value type is
 * the mappable class, and the bound type is the unmappable class.
 * 
 */
public class PropertiesAdapter extends
		XmlAdapter<AdaptedList, Map<String, List<String>>> {

	@Override
	public AdaptedList marshal(Map<String, List<String>> arg0) throws Exception {
		if (arg0.isEmpty())
			return null;
		AdaptedList myMapType = new AdaptedList();
		for (Entry<String, List<String>> entry : arg0.entrySet()) {
			Property myMapEntryType = new Property();
			myMapEntryType.setName(entry.getKey());
			myMapEntryType.setValues(entry.getValue());
			myMapType.property.add(myMapEntryType);
		}
		return myMapType;
	}

	@Override
	public Map<String, List<String>> unmarshal(AdaptedList arg0) throws Exception {
		if (arg0.property.isEmpty())
			return null;
		HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
		for (Property myEntryType : arg0.property) {
			hashMap.put(myEntryType.getName(), myEntryType.getValues());
		}
		return hashMap;
	}

}
