/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.usagetracker.rest.resources;

import java.net.UnknownHostException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.apache.log4j.Logger;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.exception.NotAuthorizedException;
import org.gcube.accounting.exception.rest.NotFoundException;
import org.gcube.accounting.exception.rest.ServerErrorException;
import org.gcube.accounting.security.SecurityManager;
import org.gcube.accounting.security.authz.Action;
import org.gcube.accounting.usagetracker.persistence.UsageTrackerDB;

public abstract class AbstractRecordResource<T extends UsageRecord> {
    private String id;
    private String userId;
    private static Logger logger = Logger.getLogger(AbstractRecordResource.class);

    public AbstractRecordResource() {
    }

    public AbstractRecordResource(String id) {
        this.id = id;
    }

    @GET
    @Produces(value={"application/xml"})
    public T getRecord() throws NotAuthorizedException {
        if (!SecurityManager.isAllowed((String)this.userId, (Action)Action.READ_RECORD)) {
            logger.info((Object)("User " + this.userId + " doesn't have permission to perform " + Action.READ_RECORD));
            throw new NotAuthorizedException();
        }
        try {
            UsageTrackerDB db = UsageTrackerDB.getStorage();
            UsageRecord r = db.getUsageRecord(this.id);
            String fullyQualifiedConsumerId = r.getFullyQualifiedConsumerId();
            if (!SecurityManager.isAllowed((String)this.userId, (Action)Action.READ_RECORD, (String)fullyQualifiedConsumerId)) {
                logger.info((Object)("User " + this.userId + " doesn't have permission to perform " + Action.READ_RECORD + " on record " + this.id));
                throw new NotAuthorizedException();
            }
            if (!this.isCorrectType(r)) {
                String message = "record " + r.getId() + " does not match the requested resource type";
                logger.info((Object)message);
                throw new NotFoundException(message);
            }
            return (T)this.createRecord(r);
        }
        catch (UnknownHostException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ServerErrorException(e.getMessage());
        }
        catch (org.gcube.accounting.exception.NotFoundException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new NotFoundException(e.getMessage());
        }
        catch (InvalidValueException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
            throw new NotFoundException(e.getMessage());
        }
    }

    protected abstract void validate(T var1) throws InvalidValueException;

    protected abstract T createRecord(UsageRecord var1) throws InvalidValueException;

    protected abstract boolean isCorrectType(UsageRecord var1);

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
}

