package org.gcube.accounting.service.rest;

import java.util.List;

import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.accounting.service.AccountingResource;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Response.Status;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
@RequestHeaders ({
	  @RequestHeader( name = "Authorization", description = "Bearer token, see <a href=\"https://dev.d4science.org/how-to-access-resources\">https://dev.d4science.org/how-to-access-resources</a>")
})
@Path(RecordManagement.RECORD_PATH_PART)
public class RecordManagement {
	
	private static final Logger logger = LoggerFactory.getLogger(RecordManagement.class);
	
	public static final String RECORD_PATH_PART = "record";
	public static final String TYPE_PATH_PART = "type";
	public static final String RECORD_ID_PATH_PART = "recordID";
	
	@POST
	@Consumes({MediaType.TEXT_PLAIN, AccountingResource.APPLICATION_JSON_CHARSET_UTF_8})
	public Response add(String json) throws Exception {
		InnerMethodName.set("POST /" + RecordManagement.RECORD_PATH_PART);
		
		logger.trace("Going to account : {}", json);
		
		AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
		
		List<Record> records = DSMapper.unmarshalList(json);
		for(Record record : records) {
			accountingPersistence.account(record);
		}
		
		logger.trace("{} accounted successfully", json);
		
		return Response.status(Status.CREATED).build();
	}
	
}
