/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.service.resources;

import com.sun.research.ws.wadl.HTTPMethods;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQuery;
import org.gcube.accounting.analytics.persistence.AccountingPersistenceQueryFactory;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.accounting.service.AccountingServiceInitializer;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.documentstore.records.DSMapper;
import org.gcube.documentstore.records.Record;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=AccountingServiceInitializer.class)
@Path(value="record")
public class RecordManagement {
    private static final Logger log = LoggerFactory.getLogger(RecordManagement.class);
    public static final String RECORD_PATH_PART = "record";
    public static final String TYPE_PATH_PART = "type";
    public static final String RECORD_ID_PATH_PART = "recordID";

    @POST
    @Consumes(value={"text/plain", "application/json;charset=UTF-8"})
    public Response add(String json) throws Exception {
        CalledMethodProvider.instance.set(HTTPMethods.POST.name() + " /" + RECORD_PATH_PART);
        log.trace("Going to account : {}", (Object)json);
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        List records = DSMapper.unmarshalList((String)json);
        for (Record record : records) {
            accountingPersistence.account(record);
        }
        log.trace("{} accounted successfully", (Object)json);
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @GET
    @Path(value="/{type}/{recordID}/")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response get(@NotNull @PathParam(value="type") String type, @NotNull @PathParam(value="recordID") String recordId) throws Exception {
        CalledMethodProvider.instance.set(HTTPMethods.GET.name() + " /" + TYPE_PATH_PART + "/" + RECORD_ID_PATH_PART);
        log.debug("Requested {} having ID {}", (Object)type, (Object)recordId);
        AccountingPersistenceQuery accountingPersistenceQuery = AccountingPersistenceQueryFactory.getInstance();
        String record = accountingPersistenceQuery.getRecord(recordId, type);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)record).type("application/json;charset=UTF-8").build();
    }
}

