/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.implementation.AggregatedField;
import org.gcube.documentstore.records.implementation.RequiredField;
import org.gcube.documentstore.records.implementation.validations.annotations.ValidLong;

public class AggregatedStorageUsageRecord
extends AbstractStorageUsageRecord
implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {
    private static final long serialVersionUID = 1082525518686785682L;
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";

    public AggregatedStorageUsageRecord() {
    }

    public AggregatedStorageUsageRecord(Map<String, Comparable<? extends Serializable>> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedStorageUsageRecord(StorageUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    public int getOperationCount() {
        return super.getOperationCount();
    }

    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    public AggregatedStorageUsageRecord aggregate(AggregatedStorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            this.setOperationCount(this.getOperationCount() + record.getOperationCount());
            this.setDataVolume(this.getDataVolume() + record.getDataVolume());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
        return this;
    }

    public AggregatedStorageUsageRecord aggregate(StorageUsageRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedStorageUsageRecord(record));
        }
        catch (InvalidValueException e) {
            throw new NotAggregatableRecordsExceptions(e.getCause());
        }
    }

    public Class<StorageUsageRecord> getAggregable() {
        return StorageUsageRecord.class;
    }
}

