/**
 * 
 */
package org.gcube.accounting.datamodel.backwardcompatibility;

import java.io.Serializable;

import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.decorators.FieldAction;
import org.gcube.accounting.exception.InvalidValueException;

public class MoveToScopeAction implements FieldAction {
	@Override
	public Serializable validate(String key, Serializable value, UsageRecord usageRecord) throws InvalidValueException  {
		if(value instanceof String){
			usageRecord.setScope((String) value);
		}else{
			throw new InvalidValueException();
		}
		return value;
	}
}