/**
 * 
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.AggregatedServiceUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class ServiceUsageRecordAggregationStrategy extends AggregationStrategy<AggregatedServiceUsageRecord, ServiceUsageRecord>{

	/**
	 * @param serviceUsageRecord
	 */
	public ServiceUsageRecordAggregationStrategy(AggregatedServiceUsageRecord serviceUsageRecord) {
		super(serviceUsageRecord);
		this.aggregationField.add(AggregatedServiceUsageRecord.CALLER_HOST);
		this.aggregationField.add(AggregatedServiceUsageRecord.HOST);
		this.aggregationField.add(AggregatedServiceUsageRecord.SERVICE_CLASS);
		this.aggregationField.add(AggregatedServiceUsageRecord.SERVICE_NAME);
		this.aggregationField.add(AggregatedServiceUsageRecord.CALLED_METHOD);
	}
	
	protected long durationWeightedAverage(AggregatedServiceUsageRecord record){
		long tDuration = t.getDuration() * t.getOperationCount();
		long recordDuration = record.getDuration() * record.getOperationCount();
		long totalOperationCount = t.getOperationCount() + record.getOperationCount();
		return (tDuration + recordDuration) / totalOperationCount;
	}

	protected AggregatedServiceUsageRecord reallyAggregate(AggregatedServiceUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		
		try {
			t.setDuration(durationWeightedAverage(record));
			t.setOperationCount(t.getOperationCount() + record.getOperationCount());
			
			
			long max = record.getMaxInvocationTime();
			if(max > t.getMaxInvocationTime()){
				t.setMaxInvocationTime(max);
			}
			
			long min = record.getMinInvocationTime();
			if(min < t.getMinInvocationTime()){
				t.setMinInvocationTime(min);
			}
			
		}catch(Exception e){
			throw new UnsupportedOperationException(e);
		}
		
		return t;
	}

}
