/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.basetypes;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.UUID;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUsageRecord {
    private static final Logger logger = LoggerFactory.getLogger(TestUsageRecord.class);
    public static final String TEST_CONSUMER_ID = "name.surname";
    public static final String TEST_SCOPE = "/infrastructure/vo";
    public static final String TEST_SERVICE_CLASS = "TestServiceClass";
    public static final String TEST_SERVICE_NAME = "TestServiceName";
    public static final String TEST_CALLED_METHOD = "TestCalledMethod";
    public static final String TEST_CALLER_HOST = "remotehost";
    public static final String TEST_HOST = "localhost";
    public static final String TEST_PROPERTY_NAME = "TestPropertyName";
    public static final String TEST_PROPERTY_VALUE = "TestPropertyValue";
    public static final String TEST_JOB_NAME = "TestJobName";
    public static final int TEST_VMS_USED = 2;
    public static final String TEST_JOB_QUALIFIER = "TestJobQualifier";
    public static final long HALF_DURATION = 600000L;
    public static final UsageRecord.OperationResult TEST_JOB_OPERATION_RESULT = UsageRecord.OperationResult.SUCCESS;
    private static final long MIN_DURATION = 60L;
    private static final long MAX_DURATION = 1000L;
    public static final String TEST_RESOUCE_OWNER = "resource.owner";
    public static final String TEST_RESOUCE_SCOPE = "/infrastructure/vo";
    public static final String TEST_RESOURCE_URI = "testprotocol://objectURI";
    public static final String TEST_PROVIDER_URI = "testprotocol://providerURI";
    private static final long MIN_DATA_VOLUME = 1024L;
    private static final long MAX_DATA_VOLUME = 10240L;

    public static long generateRandomLong(long min, long max) {
        return min + (long)((int)(Math.random() * (double)(max - min + 1L)));
    }

    public static ServiceUsageRecord createTestServiceUsageRecordExplicitScope() throws InvalidValueException {
        ServiceUsageRecord usageRecord = TestUsageRecord.createTestServiceUsageRecordAutomaticScope();
        try {
            usageRecord.setScope("/infrastructure/vo");
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Setting the Scope", (Throwable)e);
            throw e;
        }
        return usageRecord;
    }

    public static ServiceUsageRecord createTestServiceUsageRecordAutomaticScope() {
        ServiceUsageRecord usageRecord = new ServiceUsageRecord();
        try {
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            usageRecord.setCallerHost(TEST_CALLER_HOST);
            usageRecord.setHost(TEST_HOST);
            usageRecord.setServiceClass(TEST_SERVICE_CLASS);
            usageRecord.setServiceName(TEST_SERVICE_NAME);
            usageRecord.setCalledMethod(TEST_CALLED_METHOD);
            usageRecord.setDuration(TestUsageRecord.generateRandomLong(60L, 1000L));
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", (Throwable)e);
            throw new RuntimeException(e);
        }
        return usageRecord;
    }

    public static StorageUsageRecord createTestStorageUsageRecordExplicitScope() {
        StorageUsageRecord usageRecord = TestUsageRecord.createTestStorageUsageRecordAutomaticScope();
        try {
            usageRecord.setScope("/infrastructure/vo");
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Setting the Scope", (Throwable)e);
            throw new RuntimeException(e);
        }
        return usageRecord;
    }

    public static StorageUsageRecord createTestStorageUsageRecordAutomaticScope() {
        StorageUsageRecord usageRecord = new StorageUsageRecord();
        try {
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            usageRecord.setResourceOwner(TEST_RESOUCE_OWNER);
            usageRecord.setResourceScope("/infrastructure/vo");
            usageRecord.setResourceURI(new URI(TEST_RESOURCE_URI));
            usageRecord.setProviderURI(new URI(TEST_PROVIDER_URI));
            usageRecord.setOperationType(AbstractStorageUsageRecord.OperationType.READ);
            usageRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            usageRecord.setDataVolume(TestUsageRecord.generateRandomLong(1024L, 10240L));
            usageRecord.setQualifier("image/png");
        }
        catch (URISyntaxException | InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", (Throwable)e);
            throw new RuntimeException(e);
        }
        return usageRecord;
    }

    public static JobUsageRecord createTestJobUsageRecordExplicitScope() {
        JobUsageRecord usageRecord = TestUsageRecord.createTestJobUsageRecordAutomaticScope();
        try {
            usageRecord.setScope("/infrastructure/vo");
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Setting the Scope", (Throwable)e);
            throw new RuntimeException(e);
        }
        return usageRecord;
    }

    public static JobUsageRecord createTestJobUsageRecordAutomaticScope() {
        JobUsageRecord usageRecord = new JobUsageRecord();
        try {
            usageRecord.setJobId(UUID.randomUUID().toString());
            usageRecord.setJobQualifier(TEST_JOB_QUALIFIER);
            usageRecord.setConsumerId(TEST_CONSUMER_ID);
            usageRecord.setOperationResult(TEST_JOB_OPERATION_RESULT);
            usageRecord.setJobName(TEST_JOB_NAME);
            Calendar startTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            endTime.setTimeInMillis(startTime.getTimeInMillis() + 600000L);
            startTime.setTimeInMillis(startTime.getTimeInMillis() - 600000L);
            usageRecord.setJobStartTime(startTime);
            usageRecord.setJobEndTime(endTime);
            usageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            usageRecord.setVmsUsed(2);
        }
        catch (InvalidValueException e) {
            logger.error(" ------ You SHOULD NOT SEE THIS MESSAGE. Error Creating a test Usage Record", (Throwable)e);
        }
        return usageRecord;
    }
}

