/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

public class AggregatedStorageUsageRecord
extends AbstractStorageUsageRecord
implements AggregatedUsageRecord<AggregatedStorageUsageRecord, StorageUsageRecord> {
    private static final long serialVersionUID = 1082525518686785682L;
    @RequiredField
    @ValidLong
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";

    private void init() {
        this.resourceProperties.put("aggregated", true);
    }

    public AggregatedStorageUsageRecord() {
        this.init();
    }

    public AggregatedStorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
        this.init();
    }

    public AggregatedStorageUsageRecord(StorageUsageRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
        this.init();
    }

    @Override
    public int getOperationCount() {
        return super.getOperationCount();
    }

    @Override
    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    @Override
    public AggregatedStorageUsageRecord getAggregatedUsageRecord(StorageUsageRecord usageRecord) throws InvalidValueException {
        return new AggregatedStorageUsageRecord(usageRecord);
    }
}

