/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractJobUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.JobUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AggregatedJobUsageRecord extends AbstractJobUsageRecord implements AggregatedUsageRecord<AggregatedJobUsageRecord, JobUsageRecord> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -3376423316219914682L;
	
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public AggregatedJobUsageRecord(){
		super();
		init();
	}
	
	public AggregatedJobUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}

	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}
	
	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedJobUsageRecord getAggregatedUsageRecord(JobUsageRecord b)
			throws InvalidValueException {
		// TODO Auto-generated method stub
		return null;
	}

	
}
