/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractTaskUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.TaskUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AggregatedTaskUsageRecord extends AbstractTaskUsageRecord implements AggregatedUsageRecord<AggregatedTaskUsageRecord, TaskUsageRecord> {

	
	/**
	 * Generated Serial version UID
	 */
	private static final long serialVersionUID = 7445526162102677455L;
	
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public AggregatedTaskUsageRecord(){
		super();
		init();
	}
	
	public AggregatedTaskUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}

	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}
	
	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedTaskUsageRecord getAggregatedUsageRecord(TaskUsageRecord usageRecord)
			throws InvalidValueException {
		// TODO Auto-generated method stub
		return null;
	}

}
