/**
 * 
 */
package org.gcube.accounting.aggregation;

import java.io.Serializable;
import java.util.Map;

import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractPortletUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.PortletUsageRecord;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * This Class is for library internal use only
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class AggregatedPortletUsageRecord extends AbstractPortletUsageRecord implements AggregatedUsageRecord<AggregatedPortletUsageRecord, PortletUsageRecord> {

	
	/**
	 * Generated Serial version UID
	 */
	private static final long serialVersionUID = 7445526162102677455L;
	
	private void init(){
		this.resourceProperties.put(AGGREGATED, true);
	}
	
	public AggregatedPortletUsageRecord(){
		super();
		init();
	}
	
	public AggregatedPortletUsageRecord(Map<String, Serializable> properties) throws InvalidValueException{
		super(properties);
		init();
	}

	@Override
	public int getOperationCount() {
		return super.getOperationCount();
	}
	
	@Override
	public void setOperationCount(int operationCount) throws InvalidValueException {
		super.setOperationCount(operationCount);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public AggregatedPortletUsageRecord getAggregatedUsageRecord(PortletUsageRecord usageRecord)
			throws InvalidValueException {
		// TODO Auto-generated method stub
		return null;
	}

}
