/**
 * 
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.ServiceUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class ServiceUsageRecordAggregationStrategy extends AggregationStrategy<ServiceUsageRecord, org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord>{

	/**
	 * @param serviceUsageRecord
	 */
	public ServiceUsageRecordAggregationStrategy(ServiceUsageRecord serviceUsageRecord) {
		super(serviceUsageRecord);
		this.aggregationField.add(ServiceUsageRecord.CALLER_HOST);
		this.aggregationField.add(ServiceUsageRecord.HOST);
		this.aggregationField.add(ServiceUsageRecord.SERVICE_CLASS);
		this.aggregationField.add(ServiceUsageRecord.SERVICE_NAME);
		this.aggregationField.add(ServiceUsageRecord.CALLED_METHOD);
	}
	
	protected long durationWeightedAverage(ServiceUsageRecord record){
		long tDuration = t.getDuration() * t.getOperationCount();
		long recordDuration = record.getDuration() * record.getOperationCount();
		long totalOperationCount = t.getOperationCount() + record.getOperationCount();
		return (tDuration + recordDuration) / totalOperationCount;
	}

	protected ServiceUsageRecord reallyAggregate(ServiceUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		
		try {
			t.setDuration(durationWeightedAverage(record));
			t.setOperationCount(t.getOperationCount() + record.getOperationCount());
			
			
			long max = record.getMaxInvocationTime();
			if(max > t.getMaxInvocationTime()){
				t.setMaxInvocationTime(max);
			}
			
			long min = record.getMinInvocationTime();
			if(min < t.getMinInvocationTime()){
				t.setMinInvocationTime(min);
			}
			
		}catch(Exception e){
			throw new UnsupportedOperationException(e);
		}
		
		return t;
	}

}
