/**
 * 
 */
package org.gcube.accounting.datamodel;

import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public interface AggregatedUsageRecord<T extends AggregatedUsageRecord<T, B>, B extends SingleUsageRecord> extends UsageRecord {
	
	@AggregatedField @ValidInteger
	public static final String OPERATION_COUNT = "operationCount";
	
	public T getAggregatedUsageRecord(B usageRecord) throws InvalidValueException ;
	
}
