/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.aggregation.scheduler;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gcube.accounting.aggregation.ServiceUsageRecord;
import org.gcube.accounting.aggregation.scheduler.BufferAggregationScheduler;
import org.gcube.accounting.aggregation.strategy.ServiceUsageRecordAggregationStrategy;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;
import org.gcube.accounting.persistence.AccountingPersistenceExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregationScheduler {
    private static Logger logger = LoggerFactory.getLogger(AggregationScheduler.class);
    protected static AggregationScheduler aggregationScheduler = new BufferAggregationScheduler();
    protected int totalBufferedRecords = 0;
    protected Map<String, List<AggregationStrategy>> records = new HashMap<String, List<AggregationStrategy>>();
    protected List<UsageRecord> unaggregableRecords = new ArrayList<UsageRecord>();

    public static AggregationScheduler getInstance() {
        return aggregationScheduler;
    }

    protected AggregationScheduler() {
    }

    protected Class<? extends AggregatedUsageRecord> getAggregatedUsageRecordClass(String usageRecordName) throws ClassNotFoundException {
        Class<?> clz;
        try {
            Package aggregatedPackage = ServiceUsageRecord.class.getPackage();
            String aggregatedURFullyQualifiedName = String.format("%s.%s", aggregatedPackage.getName(), usageRecordName);
            clz = Class.forName(aggregatedURFullyQualifiedName);
        }
        catch (ClassNotFoundException e) {
            logger.error("Unable To find the Aggregation Class for {}", (Object)usageRecordName);
            throw e;
        }
        return clz;
    }

    protected AggregatedUsageRecord instantiateAggregatedUsageRecord(UsageRecord usageRecord) throws Exception {
        String usageRecordName = usageRecord.getClass().getSimpleName();
        Class<? extends AggregatedUsageRecord> clz = this.getAggregatedUsageRecordClass(usageRecordName);
        Class[] argTypes = new Class[]{usageRecord.getClass()};
        Constructor<? extends AggregatedUsageRecord> constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{usageRecord};
        return constructor.newInstance(arguments);
    }

    protected Class<? extends AggregationStrategy> getAggregattionStrategyUsageRecordClass(String usageRecordName) throws ClassNotFoundException {
        Class<?> clz;
        try {
            Package aggregationStrategyPackage = ServiceUsageRecordAggregationStrategy.class.getPackage();
            String aggregationStrategyName = String.format("%s.%s%s", aggregationStrategyPackage.getName(), usageRecordName, AggregationStrategy.class.getSimpleName());
            clz = Class.forName(aggregationStrategyName);
        }
        catch (Exception e) {
            logger.error("Unable To find the Aggregation Strategy Class for {}", (Object)usageRecordName);
            throw e;
        }
        return clz;
    }

    protected AggregationStrategy instantiateAggregationStrategy(AggregatedUsageRecord aggregatedUsageRecord) throws Exception {
        String usageRecordName = aggregatedUsageRecord.getClass().getSimpleName();
        Class<? extends AggregationStrategy> clz = this.getAggregattionStrategyUsageRecordClass(usageRecordName);
        Class[] argTypes = new Class[]{aggregatedUsageRecord.getClass()};
        Constructor<? extends AggregationStrategy> constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{aggregatedUsageRecord};
        return constructor.newInstance(arguments);
    }

    protected void madeAggregation(UsageRecord usageRecord) {
        AggregatedUsageRecord aggregatedUsageRecord;
        List<Object> aggregationStrategies;
        String usageRecordName = usageRecord.getClass().getSimpleName();
        if (this.records.containsKey(usageRecordName)) {
            aggregationStrategies = this.records.get(usageRecordName);
            boolean found = false;
            for (AggregationStrategy aggregationStrategy : aggregationStrategies) {
                try {
                    aggregationStrategy.aggregate((SingleUsageRecord)usageRecord);
                    found = true;
                    break;
                }
                catch (NotAggregatableRecordsExceptions e) {
                    logger.trace("{} is not usable for aggregation", (Object)aggregationStrategy);
                }
            }
            if (found) {
                return;
            }
        } else {
            aggregationStrategies = new ArrayList();
            this.records.put(usageRecordName, aggregationStrategies);
        }
        if (usageRecord instanceof AggregatedUsageRecord) {
            aggregatedUsageRecord = (AggregatedUsageRecord)usageRecord;
        } else {
            try {
                aggregatedUsageRecord = this.instantiateAggregatedUsageRecord(usageRecord);
            }
            catch (Exception e) {
                logger.error("Unable to Istantiate the Aggregation Class for {}. The Record will be persisted as is (Better than nothing).", (Object)usageRecordName);
                this.unaggregableRecords.add(usageRecord);
                ++this.totalBufferedRecords;
                return;
            }
        }
        try {
            AggregationStrategy aggregationStrategy = this.instantiateAggregationStrategy(aggregatedUsageRecord);
            aggregationStrategies.add(aggregationStrategy);
            ++this.totalBufferedRecords;
        }
        catch (Exception e) {
            logger.error("Unable to Istantiate the Aggregation Strategy Class for {}. The Record will be persisted as is (Better than nothing).", (Object)usageRecordName);
            this.unaggregableRecords.add(usageRecord);
        }
    }

    public void flush(AccountingPersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(null, persistenceExecutor, true);
    }

    protected abstract void specificClear();

    protected void clear() {
        this.totalBufferedRecords = 0;
        this.records.clear();
        this.unaggregableRecords.clear();
        this.specificClear();
    }

    protected synchronized void aggregate(SingleUsageRecord usageRecord, AccountingPersistenceExecutor persistenceExecutor, boolean forceFlush) throws Exception {
        if (usageRecord != null) {
            this.madeAggregation(usageRecord);
        }
        if (this.isTimeToPersist() || forceFlush) {
            UsageRecord[] recordToPersist = new UsageRecord[this.totalBufferedRecords];
            int i = 0;
            Collection<List<AggregationStrategy>> values = this.records.values();
            for (List<AggregationStrategy> startegies : values) {
                for (AggregationStrategy startegy : startegies) {
                    recordToPersist[i] = startegy.getAggregatedUsageRecord();
                    ++i;
                }
            }
            Iterator<Object> i$ = this.unaggregableRecords.iterator();
            while (i$.hasNext()) {
                UsageRecord record;
                recordToPersist[i] = record = (UsageRecord)i$.next();
                ++i;
            }
            persistenceExecutor.persist(recordToPersist);
            this.clear();
        }
    }

    public void aggregate(SingleUsageRecord usageRecord, AccountingPersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(usageRecord, persistenceExecutor, false);
    }

    protected abstract boolean isTimeToPersist();
}

