/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gcube.accounting.aggregation.scheduler.AggregationScheduler;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.exception.InvalidValueException;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.accounting.persistence.AccountingPersistenceExecutor;
import org.gcube.accounting.persistence.FallbackPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccountingPersistence {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistence.class);
    protected FallbackPersistence fallback;
    protected AggregationScheduler aggregationScheduler;
    private ExecutorService pool;

    protected AccountingPersistence() {
        this.pool = Executors.newCachedThreadPool();
    }

    protected AccountingPersistence(FallbackPersistence fallback, AggregationScheduler aggregationScheduler) {
        this.fallback = fallback;
        this.aggregationScheduler = aggregationScheduler;
        this.pool = Executors.newCachedThreadPool();
    }

    protected void setFallback(FallbackPersistence fallback) {
        this.fallback = fallback;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(AccountingPersistenceConfiguration var1) throws Exception;

    protected abstract void reallyAccount(UsageRecord var1) throws Exception;

    private void accountWithFallback(UsageRecord ... usageRecords) {
        String persistenceName = this.getClass().getSimpleName();
        for (UsageRecord usageRecord : usageRecords) {
            try {
                this.reallyAccount(usageRecord);
                logger.debug("{} accounted succesfully from {}.", (Object)usageRecord.toString(), (Object)persistenceName);
            }
            catch (Exception e) {
                String fallabackPersistenceName = this.fallback.getClass().getSimpleName();
                try {
                    logger.error("{} was not accounted succesfully from {}. Trying to use {}.", new Object[]{usageRecord.toString(), persistenceName, fallabackPersistenceName});
                    this.fallback.reallyAccount(usageRecord);
                    logger.debug("{} accounted succesfully from {}", (Object)usageRecord.toString(), (Object)fallabackPersistenceName);
                }
                catch (Exception ex) {
                    logger.error("{} was not accounted at all", (Object)usageRecord.toString());
                }
            }
        }
    }

    protected void validateAccountAggregate(SingleUsageRecord usageRecord, boolean validate, boolean aggregate) {
        try {
            if (validate) {
                usageRecord.validate();
            }
            if (aggregate) {
                final AccountingPersistence persistence = this;
                this.aggregationScheduler.aggregate(usageRecord, new AccountingPersistenceExecutor(){

                    @Override
                    public void persist(UsageRecord ... usageRecords) throws Exception {
                        persistence.accountWithFallback(usageRecords);
                    }
                });
            } else {
                this.accountWithFallback(usageRecord);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating UsageRecord", e.getCause());
        }
        catch (Exception e) {
            logger.error("Error accounting UsageRecord", e.getCause());
        }
    }

    public void account(final SingleUsageRecord usageRecord) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AccountingPersistence.this.validateAccountAggregate(usageRecord, true, true);
            }
        };
        this.pool.execute(runnable);
    }

    public void flush() throws Exception {
        final AccountingPersistence persistence = this;
        this.aggregationScheduler.flush(new AccountingPersistenceExecutor(){

            @Override
            public void persist(UsageRecord ... usageRecords) throws Exception {
                persistence.accountWithFallback(usageRecords);
            }
        });
    }

    public abstract void close() throws Exception;
}

