/**
 * 
 */
package org.gcube.accounting.aggregation.strategy;

import org.gcube.accounting.aggregation.ServiceUsageRecord;
import org.gcube.accounting.datamodel.AggregationStrategy;
import org.gcube.accounting.exception.NotAggregatableRecordsExceptions;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class ServiceUsageRecordAggregationStrategy extends AggregationStrategy<ServiceUsageRecord, org.gcube.accounting.datamodel.usagerecords.ServiceUsageRecord>{

	/**
	 * @param serviceUsageRecord
	 */
	public ServiceUsageRecordAggregationStrategy(ServiceUsageRecord serviceUsageRecord) {
		super(serviceUsageRecord);
		this.aggregationField.add(ServiceUsageRecord.CALLER_HOST);
		this.aggregationField.add(ServiceUsageRecord.HOST);
		this.aggregationField.add(ServiceUsageRecord.SERVICE_CLASS);
		this.aggregationField.add(ServiceUsageRecord.SERVICE_NAME);
	}

	protected ServiceUsageRecord reallyAggregate(ServiceUsageRecord record)
			throws NotAggregatableRecordsExceptions {
		
		try {
			t.setOperationCount(t.getOperationCount() + record.getOperationCount());
			t.setDuration((t.getDuration() + record.getDuration()) / 2);
			
			long max = record.getMaxInvocationTime();
			if(max > t.getMaxInvocationTime()){
				t.setMaxInvocationTime(max);
			}
			
			long min = record.getMinInvocationTime();
			if(min < t.getMinInvocationTime()){
				t.setMinInvocationTime(min);
			}
			
		}catch(Exception e){
			throw new UnsupportedOperationException(e.getCause());
		}
		
		return t;
	}

}
