/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.ektorp.CouchDbConnector;
import org.ektorp.CouchDbInstance;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDBPersistence
extends Persistence {
    private static final Logger logger = LoggerFactory.getLogger(CouchDBPersistence.class);
    protected CouchDbInstance couchDbInstance;
    protected CouchDbConnector couchDbConnector;
    protected static final String HOST = "HOST";
    protected static final String DEFAULT_HOST = "localhost";
    protected static final String PORT = "PORT";
    protected static final String USERNAME = "USERNAME";
    protected static final String PASSWORD = "PASSWORD";
    protected String host = "localhost";
    protected int port = 5984;
    protected String username = "";
    protected String password = "";
    protected String dbName = "accounting";

    protected CouchDBPersistence() throws Exception {
    }

    protected HttpClient initHttpClient(String uri, int port, String username, String password) {
        StdHttpClient.Builder builder = new StdHttpClient.Builder().host(uri).port(port);
        if (username != null && username.compareTo("") != 0 && password != null && password.compareTo("") != 0) {
            builder.username(username).password(password);
        }
        HttpClient httpClient = builder.build();
        return httpClient;
    }

    protected ViewResult query(ViewQuery query) {
        ViewResult result = this.couchDbConnector.queryView(query);
        return result;
    }

    @Override
    public void close() throws Exception {
        this.couchDbConnector.getConnection().shutdown();
    }

    @Override
    protected void prepareConnection() throws Exception {
        logger.debug("Preparing Connection for {}", (Object)this.getClass().getSimpleName());
        HttpClient httpClient = this.initHttpClient(this.host, this.port, this.username, this.password);
        this.couchDbInstance = new StdCouchDbInstance(httpClient);
        this.couchDbConnector = new StdCouchDbConnector(this.dbName, this.couchDbInstance);
        this.couchDbConnector.createDatabaseIfNotExists();
    }

    protected void createItem(JsonNode node, String id) throws Exception {
        if (id != null && id.compareTo("") != 0) {
            this.couchDbConnector.create(id, (Object)node);
        } else {
            this.couchDbConnector.create((Object)node);
        }
    }

    @Override
    protected void reallyAccount(UsageRecord usageRecord) throws Exception {
        JsonNode node = CouchDBPersistence.usageRecordToJsonNode(usageRecord);
        this.createItem(node, usageRecord.getId());
    }

    public static JsonNode usageRecordToJsonNode(UsageRecord usageRecord) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree(usageRecord.getResourceProperties());
        return node;
    }

    public static UsageRecord jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        UsageRecord usageRecord = BasicUsageRecord.getUsageRecord(result);
        return usageRecord;
    }
}

