/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.implementations;

import java.io.Serializable;
import java.util.Map;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.decorators.AggregatedField;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.ValidIP;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

public class ServiceUsageRecord
extends BasicUsageRecord
implements SingleUsageRecord {
    private static final long serialVersionUID = -4214891294699473587L;
    @ValidIP
    public static final String CALLER_IP = "callerIP";
    @RequiredField
    @NotEmpty
    public static final String CALLER_SCOPE = "callerScope";
    @RequiredField
    @NotEmpty
    public static final String REF_HOST = "refHost";
    @RequiredField
    @NotEmpty
    public static final String REF_VM = "refVM";
    @NotEmpty
    @DeprecatedWarning
    protected static final String DOMAIN = "domain";
    @ValidInteger
    @AggregatedField
    protected static final String INVOCATION_COUNT = "invocationCount";
    @ValidInteger
    @AggregatedField
    protected static final String AVERAGE_INVOCATION_COUNT = "averageInvocationTime";
    @RequiredField
    @NotEmpty
    public static final String SERVICE_CLASS = "serviceClass";
    @RequiredField
    @NotEmpty
    public static final String SERVICE_NAME = "serviceName";
    @RequiredField
    @ValidLong
    public static final String DURATION = "duration";

    public ServiceUsageRecord() {
    }

    public ServiceUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public String getCallerIP() {
        return (String)this.resourceProperties.get(CALLER_IP);
    }

    public void setCallerIP(String callerIP) throws InvalidValueException {
        this.setResourceProperty(CALLER_IP, (Serializable)((Object)callerIP));
    }

    public String getCallerScope() {
        return (String)this.resourceProperties.get(CALLER_SCOPE);
    }

    public void setCallerScope(String callerScope) throws InvalidValueException {
        this.setResourceProperty(CALLER_SCOPE, (Serializable)((Object)callerScope));
    }

    public String getRefHost() {
        return (String)this.resourceProperties.get(REF_HOST);
    }

    public void setRefHost(String refHost) throws InvalidValueException {
        this.setResourceProperty(REF_HOST, (Serializable)((Object)refHost));
    }

    public String getRefVM() {
        return (String)this.resourceProperties.get(REF_VM);
    }

    public void setRefVM(String refVM) throws InvalidValueException {
        this.setResourceProperty(REF_VM, (Serializable)((Object)refVM));
    }

    public String getServiceClass() {
        return (String)this.resourceProperties.get(SERVICE_CLASS);
    }

    public void setServiceClass(String serviceClass) throws InvalidValueException {
        this.setResourceProperty(SERVICE_CLASS, (Serializable)((Object)serviceClass));
    }

    public String getServiceName() {
        return (String)this.resourceProperties.get(SERVICE_NAME);
    }

    public void setServiceName(String serviceName) throws InvalidValueException {
        this.setResourceProperty(SERVICE_NAME, (Serializable)((Object)serviceName));
    }

    public Long getDuration() {
        return (Long)this.resourceProperties.get(DURATION);
    }

    public void setDuration(Long duration) throws InvalidValueException {
        this.setResourceProperty(DURATION, duration);
    }
}

