/**
 * 
 */
package org.gcube.accounting.datamodel.implementations;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;

import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.DeprecatedWarning;
import org.gcube.accounting.datamodel.deprecationmanagement.annotations.MoveToOperationResult;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class TaskUsageRecord extends BasicUsageRecord implements SingleUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -2208425042550641240L;

	public static enum USAGE_PHASE {
		completed, failed
	};
	
	@RequiredField @NotEmpty
	public static final String JOB_ID = "jobId";
	@RequiredField @NotEmpty
	public static final String REF_HOST = "refHost";
	@RequiredField @NotEmpty
	public static final String REF_VM = "refVM";
	
	@NotEmpty @DeprecatedWarning
	protected static final String DOMAIN = "domain";
	
	@RequiredField @ValidLong
	public static final String USAGE_START_TIME = "usageStartTime";
	@RequiredField @ValidLong
	public static final String USAGE_END_TIME = "usageEndTime";
	
	@MoveToOperationResult
	protected static final String USAGE_PHASE = "usagePhase";
	
	@ValidInteger
	public static final String INPUT_FILES_NUMBER = "inputFilesNumber";
	@ValidLong
	public static final String INPUT_FILES_SIZE = "inputFilesSize";
	@ValidInteger
	public static final String OUTPUT_FILES_NUMBER = "outputFilesNumber";
	@ValidLong
	public static final String OUTPUT_FILES_SIZE = "outputFilesSize";
	@ValidLong
	public static final String OVERALL_NETWORK_IN = "overallNetworkIn";
	@ValidLong
	public static final String OVERALL_NETWORK_OUT = "overallNetworkOut";
	@ValidInteger
	public static final String CORES = "cores";
	@ValidInteger
	public static final String PROCESSORS = "processors";
	
	public TaskUsageRecord(){
		super();
	}
	
	public TaskUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
		super(properties);
	}
	
	/**
	 * @return the Job Id
	 */
	public String getJobId() {
		return (String) this.resourceProperties.get(JOB_ID);
	}

	/**
	 * @param jobId Job Id
	 * @throws InvalidValueException if fails
	 */
	public void setJobId(String jobId) throws InvalidValueException {
		setResourceProperty(JOB_ID, jobId);
	}
	
	public String getRefHost() {
		return (String) this.resourceProperties.get(REF_HOST);
	}

	public void setRefHost(String refHost) throws InvalidValueException {
		setResourceProperty(REF_HOST, refHost);
	}

	public String getRefVM() {
		return (String) this.resourceProperties.get(REF_VM);
	}

	public void setRefVM(String refVM) throws InvalidValueException {
		setResourceProperty(REF_VM, refVM);
	}

	/*
	private String getDomain() {
		return (String) this.resourceSpecificProperties.get(DOMAIN);
	}

	private void setDomain(String domain) throws InvalidValueException {
		setResourceProperty(DOMAIN, domain);
	}
	*/

	public Calendar getUsageStartTime() {
		long millis = (Long) this.resourceProperties.get(USAGE_START_TIME);
		return timestampStringToCalendar(millis);
	}
		
	public void setUsageStartTime(Calendar usageStartTime) throws InvalidValueException {
		setResourceProperty(USAGE_START_TIME, usageStartTime.getTimeInMillis());
		
	}
	
	public Calendar getUsageEndTime() {
		long millis = (Long) this.resourceProperties.get(USAGE_END_TIME);
		return timestampStringToCalendar(millis);
	}
		
	public void setUsageEndTime(Calendar usageEndTime) throws InvalidValueException {
		setResourceProperty(USAGE_END_TIME, usageEndTime.getTimeInMillis());
		
	}
	
	/*
	public USAGE_PHASE getUsagePhase() {
		return (USAGE_PHASE) this.resourceProperties.get(USAGE_PHASE);
	}

	public void setUsagePhase(USAGE_PHASE usagePhase) throws InvalidValueException {
		setResourceProperty(USAGE_PHASE, usagePhase);
	}
	*/

	public int getInputFilesNumber() {
		return (Integer) this.resourceProperties.get(INPUT_FILES_NUMBER);
	}

	public void setInputFilesNumber(int inputFilesNumber) throws InvalidValueException {
		setResourceProperty(INPUT_FILES_NUMBER, inputFilesNumber);
	}

	public long getInputFilesSize() {
		return (Long) this.resourceProperties.get(INPUT_FILES_SIZE);
	}

	public void setInputFilesSize(long inputFilesSize) throws InvalidValueException {
		setResourceProperty(INPUT_FILES_SIZE, inputFilesSize);
	}

	public int getOutputFilesNumber() {
		return (Integer) this.resourceProperties.get(OUTPUT_FILES_NUMBER);
	}

	public void setOutputFilesNumber(int outputFilesNumber) throws InvalidValueException {
		setResourceProperty(OUTPUT_FILES_NUMBER, outputFilesNumber);
	}

	public long getOutputFilesSize() {
		return (Long) this.resourceProperties.get(OUTPUT_FILES_SIZE);
	}

	public void setOutputFilesSize(long outputFilesSize) throws InvalidValueException {
		setResourceProperty(OUTPUT_FILES_SIZE, outputFilesSize);
	}
	
	public long getOverallNetworkIn() {
		return (Long) this.resourceProperties.get(OVERALL_NETWORK_IN);
	}

	public void setOverallNetworkIn(long overallNetworkIn) throws InvalidValueException {
		setResourceProperty(OVERALL_NETWORK_IN, overallNetworkIn);
	}
	
	public long getOverallNetworkOut() {
		return (Long) this.resourceProperties.get(OVERALL_NETWORK_OUT);
	}

	public void setOverallNetworkOut(long overallNetworkOut) throws InvalidValueException {
		setResourceProperty(OVERALL_NETWORK_OUT, overallNetworkOut);
	}
	
	public int getCores() {
		return (Integer) this.resourceProperties.get(CORES);
	}

	public void setCores(int cores) throws InvalidValueException {
		setResourceProperty(CORES, cores);
	}
	
	public int getProcessors() {
		return (Integer) this.resourceProperties.get(PROCESSORS);
	}

	public void setProcessors(int processors) throws InvalidValueException {
		setResourceProperty(PROCESSORS, processors);
	}
	
}
