/**
 * 
 */
package org.gcube.accounting.datamodel.implementations;

import java.io.Serializable;
import java.util.Map;

import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.SingleUsageRecord;
import org.gcube.accounting.datamodel.decorators.RequiredField;
import org.gcube.accounting.datamodel.validations.annotations.NotEmpty;
import org.gcube.accounting.datamodel.validations.annotations.NotEmptyIfNotNull;
import org.gcube.accounting.datamodel.validations.annotations.ValidIP;
import org.gcube.accounting.datamodel.validations.annotations.ValidInteger;
import org.gcube.accounting.datamodel.validations.annotations.ValidLong;
import org.gcube.accounting.datamodel.validations.annotations.ValidOperationType;
import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class StorageUsageRecord extends BasicUsageRecord implements SingleUsageRecord {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = 1381025822586583326L;

	/*
	 * Actually workspace uses
	 * DOWNLOAD, UPLOAD, COPY, MOVE, DELETE,
	 */
	public enum OperationType {
		GET, PUT, UPDATE, DELETE
	}
	
	@NotEmpty
	public static final String RESOURCE_OWNER = "resourceOwner";
	@NotEmptyIfNotNull
	public static final String PROVIDER_ID = "providerId";
	@NotEmptyIfNotNull
	public static final String OBJECT_URI = "objectURI";
	@RequiredField @ValidOperationType
	public static final String OPERATION_TYPE = "operationType";
	@NotEmpty
	public static final String QUALIFIER = "qualifier";
	@NotEmpty
	public static final String DATA_TYPE = "dataType";
	@ValidLong
	public static final String DATA_VOLUME = "dataVolume";
	@ValidInteger
	public static final String DATA_COUNT = "dataCount";
	@ValidIP
	public static final String CALLER_IP = "callerIP";
	
	public StorageUsageRecord(){
		super();
	}
	
	public StorageUsageRecord(Map<String, Serializable> properties) throws InvalidValueException {
		super(properties);
	}
	
	/**
	 * Return the identity id of the accounting owner
	 * @return The identity id of the accounting owner
	 */
	public String getResourceOwner() {
		return (String) this.resourceProperties.get(RESOURCE_OWNER);
	}
	
	/**
	 * Set the identity id of the accounting owner
	 * @param ownerID The identity id of the accounting owner
	 * @throws InvalidValueException
	 */
	public void setResourceOwner(String owner) throws InvalidValueException {
		setResourceProperty(RESOURCE_OWNER, owner);
	}
	
	public String getObjectURI() {
		return (String) this.resourceProperties.get(OBJECT_URI);
	}

	public void setObjectURI(String objectURI) throws InvalidValueException {
		setResourceProperty(OBJECT_URI, objectURI);
	}
	
	public String getOperationType() {
		return (String) this.resourceProperties.get(OPERATION_TYPE);
	}

	public void setOperationType(String operationType) throws InvalidValueException {
		setResourceProperty(OPERATION_TYPE, operationType);
	}
	
	public String getCallerIP() {
		return (String) this.resourceProperties.get(CALLER_IP);
	}

	public void setCallerIP(String callerIP) throws InvalidValueException {
		setResourceProperty(CALLER_IP, callerIP);
	}
	
	public String getProviderId() {
		return (String) this.resourceProperties.get(PROVIDER_ID);
	}

	public void setProviderId(String providerId) throws InvalidValueException {
		setResourceProperty(PROVIDER_ID, providerId);
	}
	
	public String getQualifier() {
		return (String) this.resourceProperties.get(QUALIFIER);
	}

	public void setQualifier(String qualifier) throws InvalidValueException {
		setResourceProperty(QUALIFIER, qualifier);
	}
	
	public String getDataType() {
		return (String) this.resourceProperties.get(DATA_TYPE);
	}

	public void setDataType(String dataType) throws InvalidValueException {
		setResourceProperty(DATA_TYPE, dataType);
	}
	
	public long getDataVolume() {
		return (Long) this.resourceProperties.get(DATA_VOLUME);
	}

	public void setDataVolume(long dataVolume) throws InvalidValueException {
		setResourceProperty(DATA_VOLUME, dataVolume);
	}	
	
	public int getDataCount() {
		return (Integer) this.resourceProperties.get(DATA_COUNT);
	}

	public void setDataCount(int dataCount) throws InvalidValueException {
		setResourceProperty(DATA_COUNT, dataCount);
	}
	
}
