/**
 * 
 */
package org.gcube.accounting.datamodel;

import java.util.List;

import org.gcube.accounting.exception.InvalidValueException;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public interface AggregatedUsageRecord<T> extends UsageRecord {
	
	/**
	 * Return the id of the usage record aggregating this, null if this record
	 * has not been aggregated by any record.
	 * @return Aggregated Id The ID of the aggregation Record
	 */
	public String getAggregatedUsageRecordId();

	/**
	 * Set the id of the usage record aggregating this
	 * @param aggregatedId The ID of the aggregation Record
	 * @throws InvalidValueException
	 */
	public void setAggregatedUsageRecordId(String aggregatedId)  throws InvalidValueException;
	
	/**
	 * 
	 * @param records
	 * @return
	 */
	public List<T> aggregate(List<T> records);
	
}
