/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.ast;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.query.ast.AstVisitor;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.StaticOperandImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;

public class PropertyInexistenceImpl
extends ConstraintImpl {
    private final String selectorName;
    private final String propertyName;
    private SelectorImpl selector;

    public PropertyInexistenceImpl(SelectorImpl selector, String selectorName, String propertyName) {
        this.selector = selector;
        this.selectorName = selectorName;
        this.propertyName = propertyName;
    }

    public PropertyInexistenceImpl(String selectorName, String propertyName) {
        this.selectorName = selectorName;
        this.propertyName = propertyName;
    }

    @Override
    public boolean evaluate() {
        boolean isRelative;
        boolean bl = isRelative = this.propertyName.indexOf(47) >= 0;
        if (!isRelative) {
            return this.selector.currentProperty(this.propertyName) == null;
        }
        Tree t = this.selector.currentTree();
        if (t == null) {
            return true;
        }
        String pn = this.normalizePropertyName(this.propertyName);
        String relativePath = PathUtils.getParentPath(pn);
        String name = PathUtils.getName(pn);
        for (String p : PathUtils.elements(relativePath)) {
            if (t == null || !t.exists()) {
                return false;
            }
            if (p.equals("..")) {
                t = t.isRoot() ? null : t.getParent();
                continue;
            }
            if (p.equals(".")) continue;
            t = t.getChild(p);
        }
        return t != null && t.exists() && !t.hasProperty(name);
    }

    @Override
    public Set<PropertyExistenceImpl> getPropertyExistenceConditions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SelectorImpl> getSelectors() {
        return Collections.singleton(this.selector);
    }

    @Override
    public Map<DynamicOperandImpl, Set<StaticOperandImpl>> getInMap() {
        return Collections.emptyMap();
    }

    @Override
    boolean accept(AstVisitor v) {
        return v.visit(this);
    }

    public String toString() {
        return this.quote(this.selectorName) + '.' + this.quote(this.propertyName) + " is null";
    }

    public void bindSelector(SourceImpl source) {
        this.selector = source.getExistingSelector(this.selectorName);
    }

    @Override
    public void restrict(FilterImpl f) {
    }

    @Override
    public void restrictPushDown(SelectorImpl s) {
        if (s.isOuterJoinRightHandSide()) {
            return;
        }
        if (s.equals(this.selector)) {
            s.restrictSelector(this);
        }
    }

    @Override
    public int hashCode() {
        String pn = this.normalizePropertyName(this.propertyName);
        return (this.selectorName == null ? 0 : this.selectorName.hashCode()) * 31 + (pn == null ? 0 : pn.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyInexistenceImpl other = (PropertyInexistenceImpl)obj;
        if (!PropertyInexistenceImpl.equalsStrings(this.selectorName, other.selectorName)) {
            return false;
        }
        String pn = this.normalizePropertyName(this.propertyName);
        String pn2 = this.normalizePropertyName(other.propertyName);
        return PropertyInexistenceImpl.equalsStrings(pn, pn2);
    }

    private static boolean equalsStrings(String a, String b) {
        return a == null || b == null ? a == b : a.equals(b);
    }
}

