/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.memory;

import com.google.common.base.Splitter;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernelException;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.Document;
import org.apache.jackrabbit.oak.plugins.document.DocumentStore;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.UpdateUtils;

public class MemoryDocumentStore
implements DocumentStore {
    private ConcurrentSkipListMap<String, NodeDocument> nodes = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, Document> clusterNodes = new ConcurrentSkipListMap();
    private ConcurrentSkipListMap<String, Document> settings = new ConcurrentSkipListMap();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Comparator<Revision> comparator = StableRevisionComparator.REVERSE;
    private ReadPreference readPreference;
    private WriteConcern writeConcern;
    private Object lastReadWriteMode;

    @Override
    public <T extends Document> T find(Collection<T> collection, String key, int maxCacheAge) {
        return this.find(collection, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> T find(Collection<T> collection, String key) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            Document document = (Document)map.get(key);
            return (T)document;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, int limit) {
        return this.query(collection, fromKey, toKey, null, 0L, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public <T extends Document> List<T> query(Collection<T> collection, String fromKey, String toKey, String indexedProperty, long startValue, int limit) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            SortedMap sub = map.subMap((Object)(fromKey + "\u0000"), (Object)toKey);
            ArrayList<Document> list = new ArrayList<Document>();
            for (Document doc : sub.values()) {
                Long value;
                if (indexedProperty != null && ((value = (Long)doc.get(indexedProperty)) == null || value < startValue)) continue;
                list.add(doc);
                if (list.size() < limit) continue;
                break;
            }
            ArrayList<Document> arrayList = list;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void remove(Collection<T> collection, String path) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.getMap(collection).remove(path);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <T extends Document> void remove(Collection<T> collection, List<String> keys) {
        for (String key : keys) {
            this.remove(collection, key);
        }
    }

    @Override
    @CheckForNull
    public <T extends Document> T createOrUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, false);
    }

    @Override
    public <T extends Document> T findAndUpdate(Collection<T> collection, UpdateOp update) throws MicroKernelException {
        return this.internalCreateOrUpdate(collection, update, true);
    }

    private <T extends Document> ConcurrentSkipListMap<String, T> getMap(Collection<T> collection) {
        if (collection == Collection.NODES) {
            return this.nodes;
        }
        if (collection == Collection.CLUSTER_NODES) {
            return this.clusterNodes;
        }
        if (collection == Collection.SETTINGS) {
            return this.settings;
        }
        throw new IllegalArgumentException("Unknown collection: " + collection.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private <T extends Document> T internalCreateOrUpdate(Collection<T> collection, UpdateOp update, boolean checkConditions) {
        ConcurrentSkipListMap<String, T> map = this.getMap(collection);
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            Document oldDoc = (Document)map.get(update.getId());
            T doc = collection.newDocument(this);
            if (oldDoc == null) {
                if (!update.isNew()) {
                    throw new MicroKernelException("Document does not exist: " + update.getId());
                }
            } else {
                oldDoc.deepCopy((Document)doc);
            }
            if (checkConditions && !UpdateUtils.checkConditions(doc, update)) {
                T t = null;
                return t;
            }
            UpdateUtils.applyChanges(doc, update, this.comparator);
            ((Document)doc).seal();
            map.put(update.getId(), doc);
            Document document = oldDoc;
            return (T)document;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> boolean create(Collection<T> collection, List<UpdateOp> updateOps) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            for (UpdateOp op : updateOps) {
                if (!map.containsKey(op.getId())) continue;
                boolean bl = false;
                return bl;
            }
            for (UpdateOp op : updateOps) {
                this.internalCreateOrUpdate(collection, op, false);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Document> void update(Collection<T> collection, List<String> keys, UpdateOp updateOp) {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            ConcurrentSkipListMap<String, T> map = this.getMap(collection);
            for (String key : keys) {
                if (!map.containsKey(key)) continue;
                this.internalCreateOrUpdate(collection, updateOp.shallowCopy(key), true);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Nodes:\n");
        for (String p : this.nodes.keySet()) {
            buff.append("Path: ").append(p).append('\n');
            NodeDocument doc = this.nodes.get(p);
            for (String prop : doc.keySet()) {
                buff.append(prop).append('=').append(doc.get(prop)).append('\n');
            }
            buff.append("\n");
        }
        return buff.toString();
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public void dispose() {
    }

    @Override
    public <T extends Document> T getIfCached(Collection<T> collection, String key) {
        return this.find(collection, key);
    }

    @Override
    public <T extends Document> void invalidateCache(Collection<T> collection, String key) {
    }

    @Override
    public void setReadWriteMode(String readWriteMode) {
        if (readWriteMode == null || readWriteMode.equals(this.lastReadWriteMode)) {
            return;
        }
        this.lastReadWriteMode = readWriteMode;
        try {
            WriteConcern writeConcern;
            String write;
            ReadPreference readPref;
            Map<String, String> map = Splitter.on(", ").withKeyValueSeparator(":").split(readWriteMode);
            String read = map.get("read");
            if (read != null && !(readPref = ReadPreference.valueOf(read)).equals(this.readPreference)) {
                this.readPreference = readPref;
            }
            if ((write = map.get("write")) != null && !(writeConcern = WriteConcern.valueOf(write)).equals(this.writeConcern)) {
                this.writeConcern = writeConcern;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }
}

