/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Striped;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.plugins.document.DiffCache;
import org.apache.jackrabbit.oak.plugins.document.DocumentMK;
import org.apache.jackrabbit.oak.plugins.document.MemoryDiffCache;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDiffCache
extends MemoryDiffCache {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDiffCache.class);
    private static final long MB = 0x100000L;
    private static final String COLLECTION_NAME = "changes";
    private final DBCollection changes;
    private final Cache<String, String> blacklist = CacheBuilder.newBuilder().maximumSize(1024L).build();
    private final Striped<Lock> locks = Striped.lock(16);

    public MongoDiffCache(DB db, int sizeMB, DocumentMK.Builder builder) {
        super(builder);
        this.changes = db.collectionExists(COLLECTION_NAME) ? db.getCollection(COLLECTION_NAME) : db.createCollection(COLLECTION_NAME, BasicDBObjectBuilder.start().add("capped", true).add("size", (long)sizeMB * 0x100000L).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CheckForNull
    public String getChanges(@Nonnull Revision from, @Nonnull Revision to, @Nonnull String path) {
        Lock lock = this.locks.get(from);
        lock.lock();
        try {
            String diff = super.getChanges(from, to, path);
            if (diff != null) {
                String string = diff;
                return string;
            }
            if (from.getClusterId() != to.getClusterId()) {
                String string = null;
                return string;
            }
            if (this.blacklist.getIfPresent(from + "/" + to) != null) {
                String string = null;
                return string;
            }
            Revision id = to;
            Diff d = null;
            int numCommits = 0;
            do {
                DBObject obj;
                if ((obj = this.changes.findOne(new BasicDBObject("_id", id.toString()))) == null) {
                    String string = null;
                    return string;
                }
                if (++numCommits > 32) {
                    this.blacklist.put(from + "/" + to, "");
                    String string = null;
                    return string;
                }
                if (d == null) {
                    d = new Diff(obj);
                } else {
                    d.mergeBeforeDiff(new Diff(obj));
                }
                id = Revision.fromString((String)obj.get("_b"));
                if (!from.equals(id)) continue;
                LOG.debug("Built diff from {} commits", (Object)numCommits);
                d.applyToEntry(super.newEntry(from, to)).done();
                String string = d.getChanges(path);
                return string;
            } while (StableRevisionComparator.INSTANCE.compare(id, from) >= 0);
            String string = null;
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @Nonnull
    public DiffCache.Entry newEntry(final @Nonnull Revision from, final @Nonnull Revision to) {
        return new MemoryDiffCache.MemoryEntry(from, to){
            private Diff commit;
            {
                super(x0, x1);
                this.commit = new Diff(from, to);
            }

            @Override
            public void append(@Nonnull String path, @Nonnull String changes) {
                super.append(path, changes);
                this.commit.append(path, changes);
            }

            @Override
            public void done() {
                try {
                    MongoDiffCache.this.changes.insert(this.commit.doc, WriteConcern.UNACKNOWLEDGED);
                }
                catch (MongoException e) {
                    LOG.warn("Write back of diff cache entry failed", (Throwable)e);
                }
            }
        };
    }

    static class Diff {
        private final DBObject doc;

        Diff(Revision from, Revision to) {
            this.doc = new BasicDBObject();
            this.doc.put("_id", to.toString());
            this.doc.put("_b", from.toString());
        }

        Diff(DBObject doc) {
            this.doc = doc;
        }

        void append(String path, String changes) {
            DBObject current = this.doc;
            for (String name : PathUtils.elements(path)) {
                String escName = Utils.escapePropertyName(name);
                if (current.containsField(escName)) {
                    current = (DBObject)current.get(escName);
                    continue;
                }
                BasicDBObject child = new BasicDBObject();
                current.put(escName, child);
                current = child;
            }
            current.put("_c", Preconditions.checkNotNull(changes));
        }

        String getChanges(String path) {
            String name;
            String n;
            DBObject current = this.doc;
            Iterator<String> i$ = PathUtils.elements(path).iterator();
            while (i$.hasNext() && (current = (DBObject)current.get(n = Utils.unescapePropertyName(name = i$.next()))) != null) {
            }
            if (current == null || !current.containsField("_c")) {
                return "";
            }
            return current.get("_c").toString();
        }

        DiffCache.Entry applyToEntry(DiffCache.Entry entry) {
            this.applyInternal(this.doc, "/", entry);
            return entry;
        }

        void mergeBeforeDiff(Diff before) {
            Diff.mergeInternal(this.doc, before.doc, Sets.<String>newHashSet(), Sets.<String>newHashSet(), Sets.<String>newHashSet());
            this.doc.put("_b", before.doc.get("_b"));
        }

        private static void mergeInternal(DBObject doc, DBObject before, final Set<String> added, final Set<String> removed, final Set<String> modified) {
            added.clear();
            removed.clear();
            modified.clear();
            String changes = (String)doc.get("_c");
            if (changes != null) {
                Diff.parse(changes, new ParserCallback(){

                    @Override
                    public void added(String name) {
                        added.add(name);
                    }

                    @Override
                    public void removed(String name) {
                        removed.add(name);
                    }

                    @Override
                    public void modified(String name) {
                        modified.add(name);
                    }
                });
            }
            if ((changes = (String)before.get("_c")) != null) {
                Diff.parse(changes, new ParserCallback(){

                    @Override
                    public void added(String name) {
                        if (modified.remove(name) || !removed.remove(name)) {
                            added.add(name);
                        }
                    }

                    @Override
                    public void removed(String name) {
                        if (added.remove(name)) {
                            modified.add(name);
                        } else {
                            removed.add(name);
                        }
                    }

                    @Override
                    public void modified(String name) {
                        if (added.remove(name) || !removed.contains(name)) {
                            modified.add(name);
                        }
                    }
                });
                doc.put("_c", Diff.serialize(added, removed, modified));
            }
            for (String k : before.keySet()) {
                if (!Utils.isPropertyName(k)) continue;
                DBObject beforeChild = (DBObject)before.get(k);
                DBObject thisChild = (DBObject)doc.get(k);
                if (thisChild == null) {
                    thisChild = new BasicDBObject();
                    doc.put(k, thisChild);
                }
                Diff.mergeInternal(thisChild, beforeChild, added, removed, modified);
            }
        }

        private static String serialize(Set<String> added, Set<String> removed, Set<String> modified) {
            JsopStream w = new JsopStream();
            for (String p : added) {
                w.tag('+').key(PathUtils.getName(p)).object().endObject().newline();
            }
            for (String p : removed) {
                w.tag('-').value(PathUtils.getName(p)).newline();
            }
            for (String p : modified) {
                w.tag('^').key(PathUtils.getName(p)).object().endObject().newline();
            }
            return ((Object)w).toString();
        }

        private static void parse(String changes, ParserCallback callback) {
            int r;
            JsopTokenizer t = new JsopTokenizer(changes);
            block5: while ((r = t.read()) != 0) {
                switch (r) {
                    case 43: {
                        callback.added(t.readString());
                        t.read(58);
                        t.read(123);
                        t.read(125);
                        continue block5;
                    }
                    case 45: {
                        callback.removed(t.readString());
                        continue block5;
                    }
                    case 94: {
                        callback.modified(t.readString());
                        t.read(58);
                        t.read(123);
                        t.read(125);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + ' ' + changes);
            }
        }

        private void applyInternal(DBObject obj, String path, DiffCache.Entry entry) {
            String diff = (String)obj.get("_c");
            if (diff != null) {
                entry.append(path, diff);
            }
            for (String k : obj.keySet()) {
                if (!Utils.isPropertyName(k)) continue;
                String name = Utils.unescapePropertyName(k);
                this.applyInternal((DBObject)obj.get(k), PathUtils.concat(path, name), entry);
            }
        }

        private static interface ParserCallback {
            public void added(String var1);

            public void removed(String var1);

            public void modified(String var1);
        }
    }
}

