/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.privilege;

import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.spi.security.privilege.ImmutablePrivilegeDefinition;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeConstants;
import org.apache.jackrabbit.oak.spi.security.privilege.PrivilegeDefinition;
import org.apache.jackrabbit.oak.util.TreeUtil;

public final class PrivilegeUtil
implements PrivilegeConstants {
    private PrivilegeUtil() {
    }

    @Nonnull
    public static Tree getPrivilegesTree(Root root) {
        return root.getTree("/jcr:system/rep:privileges");
    }

    @Nonnull
    public static PrivilegeDefinition readDefinition(@Nonnull Tree definitionTree) {
        String name = definitionTree.getName();
        boolean isAbstract = TreeUtil.getBoolean(definitionTree, "rep:isAbstract");
        Iterable<String> declAggrNames = null;
        PropertyState property = definitionTree.getProperty("rep:aggregates");
        if (property != null) {
            declAggrNames = property.getValue(Type.NAMES);
        }
        return new ImmutablePrivilegeDefinition(name, isAbstract, declAggrNames);
    }
}

