/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.commons.iterator.NodeTypeIteratorAdapter;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeDefinitionTemplateImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.write.NodeTypeTemplateImpl;
import org.apache.jackrabbit.oak.plugins.nodetype.write.PropertyDefinitionTemplateImpl;

public abstract class ReadWriteNodeTypeManager
extends ReadOnlyNodeTypeManager {
    @Nonnull
    protected Root getWriteRoot() {
        throw new UnsupportedOperationException();
    }

    protected void refresh() throws RepositoryException {
    }

    @Override
    public NodeTypeTemplate createNodeTypeTemplate() {
        return new NodeTypeTemplateImpl(this.getNamePathMapper());
    }

    @Override
    public NodeTypeTemplate createNodeTypeTemplate(NodeTypeDefinition ntd) throws ConstraintViolationException {
        return new NodeTypeTemplateImpl((NameMapper)this.getNamePathMapper(), ntd);
    }

    @Override
    public NodeDefinitionTemplate createNodeDefinitionTemplate() {
        return new NodeDefinitionTemplateImpl(this.getNamePathMapper());
    }

    @Override
    public PropertyDefinitionTemplate createPropertyDefinitionTemplate() {
        return new PropertyDefinitionTemplateImpl(this.getNamePathMapper());
    }

    @Override
    public NodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdate) throws RepositoryException {
        return this.registerNodeTypes(new NodeTypeDefinition[]{ntd}, allowUpdate).nextNodeType();
    }

    @Override
    public final NodeTypeIterator registerNodeTypes(NodeTypeDefinition[] ntds, boolean allowUpdate) throws RepositoryException {
        Root root = this.getWriteRoot();
        try {
            Tree tree = ReadWriteNodeTypeManager.getOrCreateNodeTypes(root);
            for (NodeTypeDefinition ntd : ntds) {
                NodeTypeTemplateImpl template = ntd instanceof NodeTypeTemplateImpl ? (NodeTypeTemplateImpl)ntd : new NodeTypeTemplateImpl((NameMapper)this.getNamePathMapper(), ntd);
                template.writeTo(tree, allowUpdate);
            }
            root.commit();
            this.refresh();
            ArrayList<NodeType> types = new ArrayList<NodeType>(ntds.length);
            for (NodeTypeDefinition ntd : ntds) {
                types.add(this.getNodeType(ntd.getName()));
            }
            return new NodeTypeIteratorAdapter(types);
        }
        catch (CommitFailedException e) {
            String message = "Failed to register node types.";
            throw e.asRepositoryException(message);
        }
    }

    private static Tree getOrCreateNodeTypes(Root root) {
        Tree types = root.getTree("/jcr:system/jcr:nodeTypes");
        if (!types.exists()) {
            Tree system = root.getTree("/jcr:system");
            if (!system.exists()) {
                system = root.getTree("/").addChild("jcr:system");
            }
            types = system.addChild("jcr:nodeTypes");
        }
        return types;
    }

    @Override
    public void unregisterNodeType(String name) throws RepositoryException {
        Root root = this.getWriteRoot();
        Tree type = root.getTree("/jcr:system/jcr:nodeTypes").getChild(this.getOakName(name));
        if (!type.exists()) {
            throw new NoSuchNodeTypeException("Node type " + name + " can not be unregistered.");
        }
        try {
            type.remove();
            root.commit();
            this.refresh();
        }
        catch (CommitFailedException e) {
            String message = "Failed to unregister node type " + name;
            throw e.asRepositoryException(message);
        }
    }

    @Override
    public void unregisterNodeTypes(String[] names) throws RepositoryException {
        Root root = this.getWriteRoot();
        Tree types = root.getTree("/jcr:system/jcr:nodeTypes");
        if (!types.exists()) {
            throw new NoSuchNodeTypeException("Node types can not be unregistered.");
        }
        try {
            for (String name : names) {
                Tree type = types.getChild(this.getOakName(name));
                if (!type.exists()) {
                    throw new NoSuchNodeTypeException("Node type " + name + " can not be unregistered.");
                }
                type.remove();
            }
            root.commit();
            this.refresh();
        }
        catch (CommitFailedException e) {
            String message = "Failed to unregister node types.";
            throw e.asRepositoryException(message);
        }
    }
}

