/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.StableRevisionComparator;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CommitQueue {
    static final Logger LOG = LoggerFactory.getLogger(CommitQueue.class);
    private final DocumentNodeStore store;
    private final SortedMap<Revision, Entry> commits = new TreeMap<Revision, Entry>(StableRevisionComparator.INSTANCE);
    private final ChangeDispatcher dispatcher;

    CommitQueue(DocumentNodeStore store, ChangeDispatcher dispatcher) {
        this.store = store;
        this.dispatcher = dispatcher;
    }

    @Nonnull
    Revision createRevision() {
        return this.createRevisions(1).first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    SortedSet<Revision> createRevisions(int num) {
        Preconditions.checkArgument(num > 0);
        TreeSet<Revision> revs = new TreeSet<Revision>(StableRevisionComparator.INSTANCE);
        Revision rev = null;
        CommitQueue commitQueue = this;
        synchronized (commitQueue) {
            for (int i = 0; i < num; ++i) {
                rev = this.store.newRevision();
                revs.add(rev);
            }
            this.commits.put(rev, new Entry(rev));
        }
        LOG.debug("created commit {}", (Object)rev);
        return revs;
    }

    void done(@Nonnull Commit commit, boolean isBranch, @Nullable CommitInfo info) {
        Preconditions.checkNotNull(commit);
        if (isBranch) {
            commit.applyToCache(commit.getBaseRevision(), true);
            this.removeCommit(commit.getRevision());
        } else {
            this.afterTrunkCommit(commit, info);
        }
    }

    void canceled(@Nonnull Revision rev) {
        this.removeCommit(rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCommit(@Nonnull Revision rev) {
        CommitQueue commitQueue = this;
        synchronized (commitQueue) {
            boolean wasHead = this.commits.firstKey().equals(rev);
            this.commits.remove(rev);
            LOG.debug("removed commit {}, wasHead={}", (Object)rev, (Object)wasHead);
            if (wasHead) {
                this.notifyHead();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterTrunkCommit(@Nonnull Commit commit, @Nullable CommitInfo info) {
        Entry commitEntry;
        boolean isHead;
        assert (!this.commits.isEmpty());
        Revision rev = commit.getRevision();
        CommitQueue commitQueue = this;
        synchronized (commitQueue) {
            isHead = this.commits.firstKey().equals(rev);
            commitEntry = (Entry)this.commits.get(rev);
        }
        if (!isHead) {
            LOG.debug("not head: {}, waiting...", (Object)rev);
            commitEntry.await();
        }
        commitQueue = this;
        synchronized (commitQueue) {
            this.commits.remove(rev);
            try {
                LOG.debug("removed {}, head is now {}", (Object)rev, this.commits.isEmpty() ? null : this.commits.firstKey());
                Revision before = this.store.getHeadRevision();
                commit.applyToCache(before, false);
                this.store.setHeadRevision(rev);
                DocumentNodeState root = this.store.getRoot();
                this.dispatcher.contentChanged(root, info);
            }
            finally {
                this.notifyHead();
            }
        }
    }

    private void notifyHead() {
        if (!this.commits.isEmpty()) {
            LOG.debug("release {}", (Object)this.commits.firstKey());
            ((Entry)this.commits.get(this.commits.firstKey())).release();
        }
    }

    private static final class Entry {
        private final Revision revision;
        private final CountDownLatch latch = new CountDownLatch(1);

        Entry(Revision revision) {
            this.revision = revision;
        }

        void release() {
            this.latch.countDown();
        }

        void await() {
            while (true) {
                try {
                    LOG.debug("awaiting {}", (Object)this.revision);
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

