/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataharvest.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.InternalServerErrorException;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.JWTSecret;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.keycloak.KeycloakClientFactory;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.dataharvest.AccountingDashboardHarvesterPlugin;
import org.gcube.resourcemanagement.support.server.managers.context.ContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAuthorization {
    private static Logger logger = LoggerFactory.getLogger(ContextAuthorization.class);
    public static final String CLIENT_ID = "accounting-dashboard-harvester-se-plugin";
    protected String clientSecret;
    protected Map<String, Secret> contextToToken;
    protected Map<Secret, String> tokenToContext;
    protected Properties properties;

    public ContextAuthorization(Properties properties) throws Exception {
        this.properties = properties;
        this.contextToToken = new HashMap<String, Secret>();
        this.tokenToContext = new HashMap<Secret, String>();
        this.retrieveContextsAndTokens();
    }

    public ContextAuthorization() throws Exception {
        this.properties = AccountingDashboardHarvesterPlugin.getConfigParameters();
        this.contextToToken = new HashMap<String, Secret>();
        this.tokenToContext = new HashMap<Secret, String>();
        this.retrieveContextsAndTokens();
    }

    private String getClientSecret(String context) {
        try {
            if (this.clientSecret == null) {
                int index = context.indexOf(47, 1);
                String root = context.substring(0, index == -1 ? context.length() : index);
                this.clientSecret = this.properties.getProperty(root);
            }
            return this.clientSecret;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("Unable to retrieve Application Token for context " + SecretManagerProvider.instance.get().getContext(), (Throwable)e);
        }
    }

    private TokenResponse getJWTAccessToken(String context) throws Exception {
        TokenResponse tr = KeycloakClientFactory.newInstance().queryUMAToken(CLIENT_ID, this.getClientSecret(context), context, null);
        return tr;
    }

    public Secret getCatalogueSecretForContext(String context) throws Exception {
        TokenResponse tr = this.getJWTAccessToken(context);
        JWTSecret secret = new JWTSecret(tr.getAccessToken());
        return secret;
    }

    protected void retrieveContextsAndTokens() throws Exception {
        LinkedHashMap map = ContextManager.readContexts();
        for (String scope : map.keySet()) {
            try {
                String context = ((ScopeBean)map.get(scope)).toString();
                Secret secret = this.getCatalogueSecretForContext(context);
                this.contextToToken.put(context, secret);
                this.tokenToContext.put(secret, context);
            }
            catch (Exception e) {
                logger.error("Error while elaborating {}", (Object)scope, (Object)e);
            }
        }
    }

    public Secret getSecretForContext(String context) {
        return this.contextToToken.get(context);
    }

    public String getContextFromSecret(Secret secret) {
        return this.tokenToContext.get(secret);
    }

    public SortedSet<String> getContexts() {
        return new TreeSet<String>(this.contextToToken.keySet());
    }
}

