/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jaxrs.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.JSONPObject;
import com.fasterxml.jackson.databind.util.JSONWrappedObject;
import com.fasterxml.jackson.jaxrs.cfg.EndpointConfigBase;
import com.fasterxml.jackson.jaxrs.json.annotation.JSONP;
import com.fasterxml.jackson.jaxrs.json.annotation.JacksonFeatures;
import java.lang.annotation.Annotation;

public class JsonEndpointConfig
extends EndpointConfigBase<JsonEndpointConfig> {
    protected JSONP.Def _jsonp;

    protected JsonEndpointConfig() {
    }

    public static JsonEndpointConfig forReading(ObjectReader objectReader, Annotation[] annotationArray) {
        return (JsonEndpointConfig)((JsonEndpointConfig)new JsonEndpointConfig().add(annotationArray, false)).initReader(objectReader);
    }

    public static JsonEndpointConfig forWriting(ObjectWriter objectWriter, Annotation[] annotationArray, String string) {
        JsonEndpointConfig jsonEndpointConfig = new JsonEndpointConfig();
        if (string != null) {
            jsonEndpointConfig._jsonp = new JSONP.Def(string);
        }
        return (JsonEndpointConfig)((JsonEndpointConfig)jsonEndpointConfig.add(annotationArray, true)).initWriter(objectWriter);
    }

    protected void addAnnotation(Class<? extends Annotation> clazz, Annotation annotation, boolean bl) {
        if (clazz == JSONP.class) {
            if (bl) {
                this._jsonp = new JSONP.Def((JSONP)annotation);
            }
        } else if (clazz == JacksonFeatures.class) {
            JacksonFeatures jacksonFeatures = (JacksonFeatures)annotation;
            if (bl) {
                this._serEnable = (SerializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])jacksonFeatures.serializationEnable());
                this._serDisable = (SerializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])jacksonFeatures.serializationDisable());
            } else {
                this._deserEnable = (DeserializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])jacksonFeatures.deserializationEnable());
                this._deserDisable = (DeserializationFeature[])JsonEndpointConfig.nullIfEmpty((Object[])jacksonFeatures.deserializationDisable());
            }
        } else {
            super.addAnnotation(clazz, annotation, bl);
        }
    }

    public Object modifyBeforeWrite(Object object) {
        return this.applyJSONP(object);
    }

    public Object applyJSONP(Object object) {
        if (this._jsonp != null) {
            if (this._jsonp.prefix != null || this._jsonp.suffix != null) {
                return new JSONWrappedObject(this._jsonp.prefix, this._jsonp.suffix, object);
            }
            if (this._jsonp.method != null) {
                return new JSONPObject(this._jsonp.method, object);
            }
        }
        return object;
    }
}

