/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.search;

import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.search.SearchRequest;
import io.opentracing.Span;
import io.opentracing.tag.Tags;

public class SearchQueryRequest
extends AbstractCouchbaseRequest
implements SearchRequest {
    private final String indexName;
    private final String payload;

    public SearchQueryRequest(String indexName, String payload, String bucket, String username, String password) {
        super(bucket, username, password);
        this.indexName = indexName;
        this.payload = payload;
    }

    @Override
    protected void afterSpanSet(Span span) {
        span.setTag(Tags.PEER_SERVICE.getKey(), "search");
    }

    @Override
    public String path() {
        return "/api/index/" + this.indexName + "/query";
    }

    public String payload() {
        return this.payload;
    }
}

