/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.ssl;

import com.couchbase.client.deps.io.netty.handler.ssl.ConscryptAlpnSslEngine;
import com.couchbase.client.deps.io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;

final class Conscrypt {
    private static final Class<?> CONSCRYPT_CLASS = Conscrypt.getConscryptClass();

    static boolean isAvailable() {
        return CONSCRYPT_CLASS != null && PlatformDependent.javaVersion() >= 8;
    }

    static boolean isEngineSupported(SSLEngine engine) {
        return Conscrypt.isAvailable() && Conscrypt.isConscryptEngine(engine, CONSCRYPT_CLASS);
    }

    private static Class<?> getConscryptClass() {
        try {
            Class<?> conscryptClass = Class.forName("org.conscrypt.Conscrypt", true, ConscryptAlpnSslEngine.class.getClassLoader());
            Conscrypt.getIsConscryptMethod(conscryptClass);
            return conscryptClass;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    private static boolean isConscryptEngine(SSLEngine engine, Class<?> conscryptClass) {
        try {
            Method method = Conscrypt.getIsConscryptMethod(conscryptClass);
            return (Boolean)method.invoke(null, engine);
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    private static Method getIsConscryptMethod(Class<?> conscryptClass) throws NoSuchMethodException {
        return conscryptClass.getMethod("isConscrypt", SSLEngine.class);
    }

    private Conscrypt() {
    }
}

