/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.io.netty.handler.codec.memcache.binary;

import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.AbstractMemcacheObject;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheMessage;

public abstract class AbstractBinaryMemcacheMessage
extends AbstractMemcacheObject
implements BinaryMemcacheMessage {
    private byte[] key;
    private ByteBuf extras;
    private ByteBuf framingExtras;
    private byte magic;
    private byte opcode;
    private short keyLength;
    private byte extrasLength;
    private byte framingExtrasLength;
    private byte dataType;
    private int totalBodyLength;
    private int opaque;
    private long cas;

    protected AbstractBinaryMemcacheMessage(byte[] key, ByteBuf extras) {
        this.key = key;
        this.extras = extras;
    }

    @Override
    public byte[] getKey() {
        return this.key;
    }

    @Override
    public ByteBuf getExtras() {
        return this.extras;
    }

    @Override
    public BinaryMemcacheMessage setKey(byte[] key) {
        this.key = key;
        return this;
    }

    @Override
    public BinaryMemcacheMessage setExtras(ByteBuf extras) {
        this.extras = extras;
        return this;
    }

    @Override
    public byte getMagic() {
        return this.magic;
    }

    @Override
    public BinaryMemcacheMessage setMagic(byte magic) {
        this.magic = magic;
        return this;
    }

    @Override
    public long getCAS() {
        return this.cas;
    }

    @Override
    public BinaryMemcacheMessage setCAS(long cas) {
        this.cas = cas;
        return this;
    }

    @Override
    public int getOpaque() {
        return this.opaque;
    }

    @Override
    public BinaryMemcacheMessage setOpaque(int opaque) {
        this.opaque = opaque;
        return this;
    }

    @Override
    public int getTotalBodyLength() {
        return this.totalBodyLength;
    }

    @Override
    public BinaryMemcacheMessage setTotalBodyLength(int totalBodyLength) {
        this.totalBodyLength = totalBodyLength;
        return this;
    }

    @Override
    public byte getDataType() {
        return this.dataType;
    }

    @Override
    public BinaryMemcacheMessage setDataType(byte dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public byte getExtrasLength() {
        return this.extrasLength;
    }

    @Override
    public BinaryMemcacheMessage setExtrasLength(byte extrasLength) {
        this.extrasLength = extrasLength;
        return this;
    }

    @Override
    public short getKeyLength() {
        return this.keyLength;
    }

    @Override
    public BinaryMemcacheMessage setKeyLength(short keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    @Override
    public byte getOpcode() {
        return this.opcode;
    }

    @Override
    public BinaryMemcacheMessage setOpcode(byte opcode) {
        this.opcode = opcode;
        return this;
    }

    @Override
    public ByteBuf getFramingExtras() {
        return this.framingExtras;
    }

    @Override
    public BinaryMemcacheMessage setFramingExtras(ByteBuf framingExtras) {
        this.framingExtras = framingExtras;
        return this;
    }

    @Override
    public byte getFramingExtrasLength() {
        return this.framingExtrasLength;
    }

    @Override
    public BinaryMemcacheMessage setFramingExtrasLength(byte framingExtrasLength) {
        this.framingExtrasLength = framingExtrasLength;
        return this;
    }

    @Override
    public int refCnt() {
        if (this.extras != null) {
            if (this.framingExtras != null && this.framingExtras.refCnt() != this.extras.refCnt()) {
                throw new IllegalStateException("framing and extras have a different refCnt, ambiguous!");
            }
            return this.extras.refCnt();
        }
        if (this.framingExtras != null) {
            return this.framingExtras.refCnt();
        }
        return 1;
    }

    @Override
    public BinaryMemcacheMessage retain() {
        if (this.extras != null) {
            this.extras.retain();
        }
        if (this.framingExtras != null) {
            this.framingExtras.retain();
        }
        return this;
    }

    @Override
    public BinaryMemcacheMessage retain(int increment) {
        if (this.extras != null) {
            this.extras.retain(increment);
        }
        if (this.framingExtras != null) {
            this.framingExtras.retain(increment);
        }
        return this;
    }

    @Override
    public boolean release() {
        boolean result = false;
        if (this.extras != null) {
            result = this.extras.release();
        }
        if (this.framingExtras != null) {
            result = this.framingExtras.release();
        }
        return result;
    }

    @Override
    public boolean release(int decrement) {
        boolean result = false;
        if (this.extras != null) {
            result = this.extras.release(decrement);
        }
        if (this.framingExtras != null) {
            result = this.framingExtras.release(decrement);
        }
        return result;
    }
}

