/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.util;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.dsl.path.index.IndexType;

public class IndexInfo {
    public static final String PRIMARY_DEFAULT_NAME = "#primary";
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(IndexInfo.class);
    private final String name;
    private final boolean isPrimary;
    private final IndexType type;
    private final String rawType;
    private final String state;
    private final String keyspace;
    private final String namespace;
    private final JsonArray indexKey;
    private final String condition;
    private final JsonObject raw;

    public IndexInfo(JsonObject raw) {
        this.raw = raw;
        this.name = raw.getString("name");
        this.state = raw.getString("state");
        this.keyspace = raw.getString("keyspace_id");
        this.namespace = raw.getString("namespace_id");
        this.indexKey = raw.getArray("index_key");
        String rawCondition = raw.getString("condition");
        this.condition = rawCondition == null ? "" : rawCondition;
        this.rawType = raw.getString("using");
        if (this.rawType == null) {
            this.type = IndexType.GSI;
        } else {
            IndexType candidateType;
            try {
                candidateType = IndexType.valueOf(this.rawType.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unknown index type {} for index {}", (Object)this.rawType, (Object)RedactableArgument.meta((Object)this.name));
                candidateType = null;
            }
            this.type = candidateType;
        }
        this.isPrimary = raw.getBoolean("is_primary") == Boolean.TRUE;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public String name() {
        return this.name;
    }

    public IndexType type() {
        return this.type;
    }

    public String rawType() {
        return this.rawType;
    }

    public String state() {
        return this.state;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String namespace() {
        return this.namespace;
    }

    public JsonArray indexKey() {
        return this.indexKey;
    }

    public String condition() {
        return this.condition;
    }

    public JsonObject raw() {
        return this.raw;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexInfo indexInfo = (IndexInfo)o;
        if (this.isPrimary != indexInfo.isPrimary) {
            return false;
        }
        if (!this.name.equals(indexInfo.name)) {
            return false;
        }
        if (!this.rawType.equals(indexInfo.rawType)) {
            return false;
        }
        if (!this.state.equals(indexInfo.state)) {
            return false;
        }
        if (!this.keyspace.equals(indexInfo.keyspace)) {
            return false;
        }
        if (!this.namespace.equals(indexInfo.namespace)) {
            return false;
        }
        if (!this.condition.equals(indexInfo.condition)) {
            return false;
        }
        return this.indexKey.equals(indexInfo.indexKey);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.isPrimary ? 1 : 0);
        result = 31 * result + this.rawType.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.keyspace.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + this.indexKey.hashCode();
        result = 31 * result + this.condition.hashCode();
        return result;
    }

    public String toString() {
        return this.raw.toString();
    }
}

