/*
 * Decompiled with CFR 0.152.
 */
package lombok.patcher.inject;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import lombok.patcher.ClassRootFinder;

public class LiveInjector {
    public void injectSelf() throws IllegalStateException {
        this.inject(ClassRootFinder.findClassRootOfSelf());
    }

    public void inject(String jarFile) throws IllegalStateException {
        File f = new File(jarFile);
        if (!f.isFile()) {
            throw new IllegalArgumentException("Live Injection is not possible unless the classpath root to inject is a jar file.");
        }
        if (System.getProperty("lombok.patcher.safeInject", null) != null) {
            this.slowInject(jarFile);
        } else {
            this.fastInject(jarFile);
        }
    }

    private void fastInject(String jarFile) throws IllegalStateException {
        try {
            Class.forName("sun.instrument.InstrumentationImpl");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("agent injection only works on a sun-derived 1.6 or higher VM");
        }
        LibJVM libjvm = (LibJVM)Native.loadLibrary(LibJVM.class);
        PointerByReference vms = new PointerByReference();
        IntByReference found = new IntByReference();
        libjvm.JNI_GetCreatedJavaVMs(vms, 1, found);
        LibInstrument libinstrument = (LibInstrument)Native.loadLibrary(LibInstrument.class);
        Pointer vm = vms.getValue();
        libinstrument.Agent_OnAttach(vm, jarFile, null);
    }

    private void slowInject(String jarFile) throws IllegalStateException {
        String ownPidS = ManagementFactory.getRuntimeMXBean().getName();
        ownPidS = ownPidS.substring(0, ownPidS.indexOf(64));
        int ownPid = Integer.parseInt(ownPidS);
        boolean unsupportedEnvironment = false;
        Throwable exception = null;
        try {
            Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            Object vm = vmClass.getMethod("attach", String.class).invoke(null, String.valueOf(ownPid));
            vmClass.getMethod("loadAgent", String.class).invoke(vm, jarFile);
        }
        catch (ClassNotFoundException e) {
            unsupportedEnvironment = true;
        }
        catch (NoSuchMethodException e) {
            unsupportedEnvironment = true;
        }
        catch (InvocationTargetException e) {
            exception = e.getCause();
            if (exception == null) {
                exception = e;
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        if (unsupportedEnvironment) {
            throw new IllegalStateException("agent injection only works on a sun-derived 1.6 or higher VM");
        }
        if (exception != null) {
            throw new IllegalStateException("agent injection not supported on this platform due to unknown reason", exception);
        }
    }

    public static interface LibJVM
    extends Library {
        public int JNI_GetCreatedJavaVMs(PointerByReference var1, int var2, IntByReference var3);
    }

    public static interface LibInstrument
    extends Library {
        public void Agent_OnAttach(Pointer var1, String var2, Pointer var3);
    }
}

