/*
 * Decompiled with CFR 0.152.
 */
package lombok.installer.eclipse;

import java.util.Arrays;
import java.util.List;
import lombok.installer.CorruptedIdeLocationException;
import lombok.installer.IdeLocation;
import lombok.installer.eclipse.EclipseFinder;
import lombok.installer.eclipse.JbdsLocationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbdsFinder
extends EclipseFinder {
    @Override
    protected IdeLocation createLocation(String guess) throws CorruptedIdeLocationException {
        return new JbdsLocationProvider().create0(guess);
    }

    @Override
    protected String getDirName() {
        return "studio";
    }

    @Override
    protected String getMacExecutableName() {
        return "jbdevstudio.app";
    }

    @Override
    protected String getUnixExecutableName() {
        return "jbdevstudio";
    }

    @Override
    protected String getWindowsExecutableName() {
        return "jbdevstudio.exe";
    }

    @Override
    protected List<String> getSourceDirsOnWindows() {
        return Arrays.asList("\\", "\\Program Files", "\\Program Files (x86)", System.getProperty("user.home", "."));
    }

    @Override
    protected List<String> getSourceDirsOnMac() {
        return Arrays.asList("/Applications", System.getProperty("user.home", "."));
    }

    @Override
    protected List<String> getSourceDirsOnUnix() {
        return Arrays.asList(System.getProperty("user.home", "."));
    }
}

